/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.pulsar.buildtools.shaded.org.apache.commons.lang3.ThreadUtils;
import org.apache.pulsar.tests.BetweenTestClassesListenerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadLeakDetectorListener
extends BetweenTestClassesListenerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadLeakDetectorListener.class);
    private static final boolean THREAD_LEAK_DETECTOR_ENABLED = Boolean.valueOf(System.getProperty("testThreadLeakDetector", "true"));
    private Set<ThreadKey> capturedThreadKeys;

    @Override
    protected void onBetweenTestClasses(Class<?> endedTestClass, Class<?> startedTestClass) {
        LOG.info("Capturing identifiers of running threads.");
        this.capturedThreadKeys = ThreadLeakDetectorListener.compareThreads(this.capturedThreadKeys, endedTestClass);
    }

    private static Set<ThreadKey> compareThreads(Set<ThreadKey> previousThreadKeys, Class<?> endedTestClass) {
        Set<ThreadKey> threadKeys = Collections.unmodifiableSet(ThreadUtils.getAllThreads().stream().map(ThreadKey::of).collect(Collectors.toCollection(LinkedHashSet::new)));
        if (endedTestClass != null && previousThreadKeys != null) {
            int newThreadsCounter = 0;
            LOG.info("Checking for new threads created by {}.", (Object)endedTestClass.getName());
            for (ThreadKey threadKey : threadKeys) {
                if (previousThreadKeys.contains(threadKey)) continue;
                ++newThreadsCounter;
                LOG.warn("Tests in class {} created thread id {} with name '{}'", new Object[]{endedTestClass.getSimpleName(), threadKey.getThreadId(), threadKey.getThreadName()});
            }
            if (newThreadsCounter > 0) {
                LOG.warn("Summary: Tests in class {} created {} new threads", (Object)endedTestClass.getName(), (Object)newThreadsCounter);
            }
        }
        return threadKeys;
    }

    private static class ThreadKey {
        private final long threadId;
        private final int threadIdentityHashCode;
        private final String threadName;

        private ThreadKey(long threadId, int threadIdentityHashCode, String threadName) {
            this.threadId = threadId;
            this.threadIdentityHashCode = threadIdentityHashCode;
            this.threadName = threadName;
        }

        static ThreadKey of(Thread thread) {
            return new ThreadKey(thread.getId(), System.identityHashCode(thread), thread.toString());
        }

        public long getThreadId() {
            return this.threadId;
        }

        public String getThreadName() {
            return this.threadName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ThreadKey threadKey = (ThreadKey)o;
            return this.threadId == threadKey.threadId && this.threadIdentityHashCode == threadKey.threadIdentityHashCode;
        }

        public int hashCode() {
            return Objects.hash(this.threadId, this.threadIdentityHashCode);
        }
    }
}

