/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.tests.RetryAnalyzer;
import org.testng.IAnnotationTransformer;
import org.testng.annotations.IConfigurationAnnotation;
import org.testng.annotations.ITestAnnotation;
import org.testng.annotations.ITestOrConfiguration;
import org.testng.internal.annotations.DisabledRetryAnalyzer;

public class AnnotationListener
implements IAnnotationTransformer {
    private static final long DEFAULT_TEST_TIMEOUT_MILLIS = TimeUnit.MINUTES.toMillis(5L);
    private static final String OTHER_GROUP = "other";

    public AnnotationListener() {
        System.out.println("Created annotation listener");
    }

    public void transform(ITestAnnotation annotation, Class testClass, Constructor testConstructor, Method testMethod) {
        if (annotation.getRetryAnalyzerClass() == null || annotation.getRetryAnalyzerClass() == DisabledRetryAnalyzer.class) {
            annotation.setRetryAnalyzer(RetryAnalyzer.class);
        }
        if (annotation.getTimeOut() == 0L) {
            annotation.setTimeOut(DEFAULT_TEST_TIMEOUT_MILLIS);
        }
        this.addToOtherGroupIfNoGroupsSpecified((ITestOrConfiguration)annotation);
    }

    private void addToOtherGroupIfNoGroupsSpecified(ITestOrConfiguration annotation) {
        if (annotation.getGroups() == null || annotation.getGroups().length == 0) {
            annotation.setGroups(new String[]{OTHER_GROUP});
        }
    }

    public void transform(IConfigurationAnnotation annotation, Class testClass, Constructor testConstructor, Method testMethod) {
        this.addToOtherGroupIfNoGroupsSpecified((ITestOrConfiguration)annotation);
    }
}

