/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ITestListener;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.SkipException;

public class FailFastNotifier
implements IInvokedMethodListener,
ITestListener {
    private static final Logger LOG = LoggerFactory.getLogger(FailFastNotifier.class);
    private static final String PROPERTY_NAME_TEST_FAIL_FAST = "testFailFast";
    private static final boolean FAIL_FAST_ENABLED = Boolean.parseBoolean(System.getProperty("testFailFast", "true"));
    private static final String PROPERTY_NAME_TEST_FAIL_FAST_FILE = "testFailFastFile";
    private static final File FAIL_FAST_KILLSWITCH_FILE = System.getProperty("testFailFastFile") != null && System.getProperty("testFailFastFile").trim().length() > 0 ? new File(System.getProperty("testFailFastFile").trim()) : null;

    public void onTestFailure(ITestResult result) {
        if (result.getThrowable() instanceof FailFastSkipException) {
            result.setThrowable(null);
            result.setStatus(3);
        } else {
            FailFastEventsSingleton.getInstance().testFailed(result);
        }
    }

    public void beforeInvocation(IInvokedMethod iInvokedMethod, ITestResult iTestResult) {
        if (FAIL_FAST_ENABLED) {
            ITestResult firstFailure = FailFastEventsSingleton.getInstance().getFirstFailure();
            if (firstFailure != null) {
                ITestNGMethod iTestNGMethod = iInvokedMethod.getTestMethod();
                if (iTestResult.getInstance() != firstFailure.getInstance() || !iTestNGMethod.isAfterMethodConfiguration() && !iTestNGMethod.isAfterClassConfiguration() && !iTestNGMethod.isAfterTestConfiguration()) {
                    throw new FailFastSkipException("Skipped after failure since testFailFast system property is set.");
                }
            } else if (FAIL_FAST_KILLSWITCH_FILE != null && FAIL_FAST_KILLSWITCH_FILE.exists()) {
                throw new FailFastSkipException("Skipped after failure since kill switch file exists.");
            }
        }
    }

    public void afterInvocation(IInvokedMethod iInvokedMethod, ITestResult iTestResult) {
    }

    static class FailFastSkipException
    extends SkipException {
        FailFastSkipException(String skipMessage) {
            super(skipMessage);
            this.reduceStackTrace();
        }
    }

    static class FailFastEventsSingleton {
        private static final FailFastEventsSingleton INSTANCE = new FailFastEventsSingleton();
        private volatile ITestResult firstFailure;

        private FailFastEventsSingleton() {
        }

        public static FailFastEventsSingleton getInstance() {
            return INSTANCE;
        }

        public ITestResult getFirstFailure() {
            return this.firstFailure;
        }

        public void testFailed(ITestResult result) {
            if (this.firstFailure == null) {
                this.firstFailure = result;
                if (FAIL_FAST_KILLSWITCH_FILE != null && !FAIL_FAST_KILLSWITCH_FILE.exists()) {
                    try {
                        Files.createFile(FAIL_FAST_KILLSWITCH_FILE.toPath(), new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        LOG.warn("Unable to create fail fast kill switch file '" + FAIL_FAST_KILLSWITCH_FILE.getAbsolutePath() + "'", (Throwable)e);
                    }
                }
            }
        }
    }
}

