/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jcloud.shade.com.google.common.collect;

import java.io.Serializable;
import org.apache.pulsar.jcloud.shade.com.google.common.annotations.GwtCompatible;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Objects;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Ordering;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ParametricNullness;
import org.apache.pulsar.jcloud.shade.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true)
final class ByFunctionOrdering<F, T>
extends Ordering<F>
implements Serializable {
    final Function<F, ? extends T> function;
    final Ordering<T> ordering;
    private static final long serialVersionUID = 0L;

    ByFunctionOrdering(Function<F, ? extends T> function, Ordering<T> ordering) {
        this.function = Preconditions.checkNotNull(function);
        this.ordering = Preconditions.checkNotNull(ordering);
    }

    @Override
    public int compare(@ParametricNullness F left, @ParametricNullness F right) {
        return this.ordering.compare(this.function.apply(left), this.function.apply(right));
    }

    @Override
    public boolean equals(@CheckForNull Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ByFunctionOrdering) {
            ByFunctionOrdering that = (ByFunctionOrdering)object;
            return this.function.equals(that.function) && this.ordering.equals(that.ordering);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.function, this.ordering);
    }

    public String toString() {
        String string = String.valueOf(this.ordering);
        String string2 = String.valueOf(this.function);
        return new StringBuilder(13 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".onResultOf(").append(string2).append(")").toString();
    }
}

