/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jcloud.shade.com.google.inject.internal;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Lists;

final class InterceptorStackCallback
implements InvocationHandler {
    private static final String GUICE_INTERNAL_AOP_PACKAGE = "org.apache.pulsar.jcloud.shade.com.google.inject.internal.aop";
    final Method method;
    final MethodInterceptor[] interceptors;
    final BiFunction<Object, Object[], Object> superInvoker;

    public InterceptorStackCallback(Method method, List<MethodInterceptor> interceptors, BiFunction<Object, Object[], Object> superInvoker) {
        this.method = method;
        this.interceptors = interceptors.toArray(new MethodInterceptor[interceptors.size()]);
        this.superInvoker = superInvoker;
    }

    @Override
    public Object invoke(Object proxy, Method unused, Object[] arguments) throws Throwable {
        return new InterceptedMethodInvocation(proxy, arguments, 0).proceed();
    }

    private void pruneStacktrace(Throwable throwable) {
        for (Throwable t = throwable; t != null; t = t.getCause()) {
            StackTraceElement[] stackTrace = t.getStackTrace();
            ArrayList<StackTraceElement> pruned = Lists.newArrayList();
            for (StackTraceElement element : stackTrace) {
                String className = element.getClassName();
                if (className.startsWith(InterceptorStackCallback.class.getName()) || className.startsWith(GUICE_INTERNAL_AOP_PACKAGE) || className.contains("$$EnhancerByGuice$$")) continue;
                pruned.add(element);
            }
            t.setStackTrace(pruned.toArray(new StackTraceElement[pruned.size()]));
        }
    }

    private class InterceptedMethodInvocation
    implements MethodInvocation {
        final Object proxy;
        final Object[] arguments;
        final int interceptorIndex;

        public InterceptedMethodInvocation(Object proxy, Object[] arguments, int interceptorIndex) {
            this.proxy = proxy;
            this.arguments = arguments;
            this.interceptorIndex = interceptorIndex;
        }

        @Override
        public Object proceed() throws Throwable {
            try {
                return this.interceptorIndex == InterceptorStackCallback.this.interceptors.length ? InterceptorStackCallback.this.superInvoker.apply(this.proxy, this.arguments) : InterceptorStackCallback.this.interceptors[this.interceptorIndex].invoke(new InterceptedMethodInvocation(this.proxy, this.arguments, this.interceptorIndex + 1));
            }
            catch (Throwable t) {
                InterceptorStackCallback.this.pruneStacktrace(t);
                throw t;
            }
        }

        @Override
        public Method getMethod() {
            return InterceptorStackCallback.this.method;
        }

        @Override
        public Object[] getArguments() {
            return this.arguments;
        }

        @Override
        public Object getThis() {
            return this.proxy;
        }

        @Override
        public AccessibleObject getStaticPart() {
            return this.getMethod();
        }
    }
}

