/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.blobstore.config;

import java.util.concurrent.TimeUnit;
import org.apache.pulsar.jcloud.shade.com.google.common.cache.CacheBuilder;
import org.apache.pulsar.jcloud.shade.com.google.common.cache.CacheLoader;
import org.apache.pulsar.jcloud.shade.com.google.common.cache.LoadingCache;
import org.apache.pulsar.jcloud.shade.com.google.inject.AbstractModule;
import org.apache.pulsar.jcloud.shade.com.google.inject.Provides;
import org.apache.pulsar.jcloud.shade.com.google.inject.Scopes;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.atmos.AtmosClient;
import org.jclouds.atmos.blobstore.AtmosBlobRequestSigner;
import org.jclouds.atmos.blobstore.AtmosBlobStore;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.attr.ConsistencyModel;

public class AtmosBlobStoreContextModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.bind(ConsistencyModel.class).toInstance(ConsistencyModel.EVENTUAL);
        this.bind(BlobStore.class).to(AtmosBlobStore.class).in(Scopes.SINGLETON);
        this.bind(BlobRequestSigner.class).to(AtmosBlobRequestSigner.class);
    }

    @Provides
    @Singleton
    protected final LoadingCache<String, Boolean> isPublic(final AtmosClient client) {
        return CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build(new CacheLoader<String, Boolean>(){

            public String toString() {
                return "isPublic()";
            }

            @Override
            public Boolean load(String arg0) throws Exception {
                return client.isPublic(arg0);
            }
        });
    }
}

