/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.filters;

import java.io.IOException;
import java.net.URI;
import java.security.InvalidKeyException;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Throwables;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableMap;
import org.apache.pulsar.jcloud.shade.com.google.common.io.BaseEncoding;
import org.apache.pulsar.jcloud.shade.com.google.common.io.ByteProcessor;
import org.apache.pulsar.jcloud.shade.com.google.common.io.ByteStreams;
import org.apache.pulsar.jcloud.shade.javax.annotation.Resource;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.apache.pulsar.jcloud.shade.javax.inject.Named;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.Macs;
import org.jclouds.date.TimeStamp;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpException;
import org.jclouds.http.Uris;
import org.jclouds.location.Provider;
import org.jclouds.logging.Logger;
import org.jclouds.util.Strings2;

@Singleton
public class ShareUrl
implements Function<String, URI> {
    private final Supplier<Credentials> creds;
    private final Supplier<URI> provider;
    private final org.apache.pulsar.jcloud.shade.javax.inject.Provider<Long> timeStampProvider;
    private final Crypto crypto;
    @Resource
    Logger logger = Logger.NULL;
    @Resource
    @Named(value="jclouds.signature")
    Logger signatureLog = Logger.NULL;

    @Inject
    public ShareUrl(@Provider Supplier<Credentials> creds, @Provider Supplier<URI> provider, @TimeStamp org.apache.pulsar.jcloud.shade.javax.inject.Provider<Long> timeStampProvider, Crypto crypto) {
        this.creds = creds;
        this.provider = provider;
        this.timeStampProvider = timeStampProvider;
        this.crypto = crypto;
    }

    @Override
    public URI apply(String path) throws HttpException {
        String requestedResource = "/rest/namespace/" + path;
        String expires = this.timeStampProvider.get().toString();
        String signature = this.signString(this.createStringToSign(requestedResource, expires));
        return Uris.uriBuilder(this.provider.get()).replaceQuery(ImmutableMap.of("uid", this.creds.get().identity, "expires", expires, "signature", signature)).appendPath(requestedResource).build();
    }

    public String createStringToSign(String requestedResource, String expires) {
        StringBuilder toSign = new StringBuilder();
        toSign.append("GET\n");
        toSign.append(requestedResource.toLowerCase()).append("\n");
        toSign.append(this.creds.get().identity).append("\n");
        toSign.append(expires);
        return toSign.toString();
    }

    public String signString(String toSign) {
        try {
            ByteProcessor<byte[]> hmacSHA1 = Macs.asByteProcessor(this.crypto.hmacSHA1(BaseEncoding.base64().decode(this.creds.get().credential)));
            return BaseEncoding.base64().encode(ByteStreams.readBytes(Strings2.toInputStream(toSign), hmacSHA1));
        }
        catch (InvalidKeyException e) {
            throw Throwables.propagate(e);
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }
}

