/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.xml;

import java.util.Date;
import java.util.Set;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Sets;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.jclouds.atmos.domain.DirectoryEntry;
import org.jclouds.atmos.domain.FileType;
import org.jclouds.date.DateService;
import org.jclouds.http.functions.ParseSax;

public class ListDirectoryResponseHandler
extends ParseSax.HandlerWithResult<Set<DirectoryEntry>> {
    private Set<DirectoryEntry> entries = Sets.newLinkedHashSet();
    private String currentObjectId;
    private FileType currentType;
    private String currentFileName;
    private long currentSize;
    private Date currentModificationTime;
    private String currentName;
    private StringBuilder currentText = new StringBuilder();
    private final DateService dateService;

    @Inject
    ListDirectoryResponseHandler(DateService dateService) {
        this.dateService = dateService;
    }

    @Override
    public Set<DirectoryEntry> getResult() {
        return this.entries;
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (qName.equals("ObjectID")) {
            this.currentObjectId = this.currentText.toString().trim();
        } else if (qName.equals("FileType")) {
            this.currentType = FileType.fromValue(this.currentText.toString().trim());
        } else if (qName.equals("Filename")) {
            this.currentFileName = this.currentText.toString().trim();
            if (this.currentFileName.equals("")) {
                this.currentFileName = null;
            }
        } else if (qName.equals("Name")) {
            this.currentName = this.currentText.toString().trim();
        } else if (qName.equals("Value")) {
            if (this.currentName.equals("size")) {
                this.currentSize = Long.parseLong(this.currentText.toString().trim());
            } else if (this.currentName.equals("mtime")) {
                this.currentModificationTime = this.dateService.iso8601DateOrSecondsDateParse(this.currentText.toString().trim());
            }
        } else if (qName.equals("DirectoryEntry")) {
            this.entries.add(new DirectoryEntry(this.currentObjectId, this.currentType, this.currentFileName, this.currentSize, this.currentModificationTime));
        }
        this.currentText.setLength(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

