/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.config;

import java.util.Set;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableSet;
import org.apache.pulsar.jcloud.shade.com.google.inject.Provides;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.aws.handlers.AWSClientErrorRetryHandler;
import org.jclouds.aws.handlers.AWSServerErrorRetryHandler;
import org.jclouds.aws.handlers.ParseAWSErrorFromXmlContent;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.rest.ConfiguresHttpApi;
import org.jclouds.rest.config.HttpApiModule;

@ConfiguresHttpApi
public abstract class AWSHttpApiModule<A>
extends HttpApiModule<A> {
    protected AWSHttpApiModule() {
    }

    protected AWSHttpApiModule(Class<A> api) {
        super(api);
    }

    @Provides
    @ClientError
    @Singleton
    protected final Set<String> provideRetryableCodes() {
        return ImmutableSet.of("RequestTimeout", "OperationAborted", "SignatureDoesNotMatch");
    }

    @Provides
    @ServerError
    @Singleton
    protected final Set<String> provideRetryableServerCodes() {
        return ImmutableSet.of("RequestLimitExceeded", "InternalError");
    }

    @Override
    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(ParseAWSErrorFromXmlContent.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(ParseAWSErrorFromXmlContent.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(ParseAWSErrorFromXmlContent.class);
    }

    @Override
    protected void bindRetryHandlers() {
        this.bind(HttpRetryHandler.class).annotatedWith(ClientError.class).to(AWSClientErrorRetryHandler.class);
        this.bind(HttpRetryHandler.class).annotatedWith(ServerError.class).to(AWSServerErrorRetryHandler.class);
    }
}

