/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.blobstore;

import java.net.URI;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.apache.pulsar.jcloud.shade.javax.inject.Named;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.azure.storage.config.AuthType;
import org.jclouds.azure.storage.filters.SharedKeyLiteAuthentication;
import org.jclouds.azure.storage.util.storageurl.StorageUrlSupplier;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.date.DateService;
import org.jclouds.date.TimeStamp;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpMessage;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.Uris;
import org.jclouds.http.options.GetOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.Provider;

@Singleton
public class AzureBlobRequestSigner
implements BlobRequestSigner {
    private static final int DEFAULT_EXPIRY_SECONDS = 900;
    private static final String API_VERSION = "2017-11-09";
    private final String identity;
    private final URI storageUrl;
    private final BlobToHttpGetOptions blob2HttpGetOptions;
    private final org.apache.pulsar.jcloud.shade.com.google.inject.Provider<String> timeStampProvider;
    private final DateService dateService;
    private final SharedKeyLiteAuthentication auth;
    private final String credential;
    private final boolean isSAS;
    private final AuthType authType;

    @Inject
    public AzureBlobRequestSigner(BlobToHttpGetOptions blob2HttpGetOptions, @TimeStamp org.apache.pulsar.jcloud.shade.com.google.inject.Provider<String> timeStampProvider, DateService dateService, SharedKeyLiteAuthentication auth, @Provider Supplier<Credentials> creds, @Named(value="sasAuth") boolean sasAuthentication, StorageUrlSupplier storageUriSupplier, AuthType authType) throws SecurityException, NoSuchMethodException {
        this.identity = creds.get().identity;
        this.credential = creds.get().credential;
        this.storageUrl = (URI)storageUriSupplier.get();
        this.blob2HttpGetOptions = Preconditions.checkNotNull(blob2HttpGetOptions, "blob2HttpGetOptions");
        this.timeStampProvider = Preconditions.checkNotNull(timeStampProvider, "timeStampProvider");
        this.dateService = Preconditions.checkNotNull(dateService, "dateService");
        this.auth = auth;
        this.isSAS = sasAuthentication;
        this.authType = authType;
    }

    @Override
    public HttpRequest signGetBlob(String container, String name) {
        return this.signGetBlob(container, name, 900L);
    }

    @Override
    public HttpRequest signGetBlob(String container, String name, long timeInSeconds) {
        Preconditions.checkNotNull(container, "container");
        Preconditions.checkNotNull(name, "name");
        return this.sign("GET", container, name, null, timeInSeconds, null, null);
    }

    @Override
    public HttpRequest signPutBlob(String container, Blob blob) {
        return this.signPutBlob(container, blob, 900L);
    }

    @Override
    public HttpRequest signPutBlob(String container, Blob blob, long timeInSeconds) {
        Preconditions.checkNotNull(container, "container");
        Preconditions.checkNotNull(blob, "blob");
        return this.sign("PUT", container, blob.getMetadata().getName(), null, timeInSeconds, blob.getMetadata().getContentMetadata().getContentLength(), blob.getMetadata().getContentMetadata().getContentType());
    }

    public HttpRequest signRemoveBlob(String container, String name) {
        Preconditions.checkNotNull(container, "container");
        Preconditions.checkNotNull(name, "name");
        return this.sign("DELETE", container, name, null, 900L, null, null);
    }

    @Override
    public HttpRequest signGetBlob(String container, String name, org.jclouds.blobstore.options.GetOptions options) {
        Preconditions.checkNotNull(container, "container");
        Preconditions.checkNotNull(name, "name");
        return this.sign("GET", container, name, this.blob2HttpGetOptions.apply(Preconditions.checkNotNull(options, "options")), 900L, null, null);
    }

    private HttpRequest signKey(String method, String container, String name, @Nullable GetOptions options, long expires, @Nullable Long contentLength, @Nullable String contentType) {
        Preconditions.checkNotNull(method, "method");
        Preconditions.checkNotNull(container, "container");
        Preconditions.checkNotNull(name, "name");
        String nowString = this.timeStampProvider.get();
        Date now = this.dateService.rfc1123DateParse(nowString);
        Date expiration = new Date(now.getTime() + TimeUnit.SECONDS.toMillis(expires));
        String iso8601 = this.dateService.iso8601SecondsDateFormat(expiration);
        String signedPermission = method.equals("PUT") ? "w" : (method.equals("DELETE") ? "d" : "r");
        Object request = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)((HttpMessage.Builder)((HttpRequest.Builder)HttpRequest.builder().method(method)).endpoint(Uris.uriBuilder(this.storageUrl).appendPath(container).appendPath(name).build())).replaceHeader("Date", nowString)).addQueryParam("sv", API_VERSION)).addQueryParam("se", iso8601)).addQueryParam("sr", "b")).addQueryParam("sp", signedPermission);
        request = this.setHeaders((HttpRequest.Builder)request, method, options, contentLength, contentType);
        String stringToSign = signedPermission + "\n\n" + iso8601 + "\n/blob/" + this.identity + "/" + container + "/" + name + "\n\n\n\n" + API_VERSION + "\n\n\n\n\n";
        String signature = this.auth.calculateSignature(stringToSign);
        ((HttpRequest.Builder)request).addQueryParam("sig", signature);
        return ((HttpRequest.Builder)request).build();
    }

    private HttpRequest.Builder setHeaders(HttpRequest.Builder request, String method, @Nullable GetOptions options, @Nullable Long contentLength, @Nullable String contentType) {
        if (contentLength != null) {
            request.replaceHeader("Content-Length", contentLength.toString());
        }
        if (contentType != null) {
            request.replaceHeader("x-ms-blob-content-type", contentType);
        }
        if (options != null) {
            request.headers(options.buildRequestHeaders());
        }
        if (method.equals("PUT")) {
            request.replaceHeader("x-ms-blob-type", "BlockBlob");
        }
        return request;
    }

    private HttpRequest signSAS(String method, String container, String name, @Nullable GetOptions options, long expires, @Nullable Long contentLength, @Nullable String contentType) {
        Preconditions.checkNotNull(method, "method");
        Preconditions.checkNotNull(container, "container");
        Preconditions.checkNotNull(name, "name");
        String nowString = this.timeStampProvider.get();
        HttpRequest.Builder request = (HttpRequest.Builder)((HttpMessage.Builder)((HttpRequest.Builder)HttpRequest.builder().method(method)).endpoint(Uris.uriBuilder(this.storageUrl).appendPath(container).appendPath(name).query(this.credential).build())).replaceHeader("Date", nowString);
        request = this.setHeaders(request, method, options, contentLength, contentType);
        return request.build();
    }

    private HttpRequest signAD(String method, String container, String name, @Nullable GetOptions options, long expires, @Nullable Long contentLength, @Nullable String contentType) {
        Preconditions.checkNotNull(method, "method");
        Preconditions.checkNotNull(container, "container");
        Preconditions.checkNotNull(name, "name");
        String nowString = this.timeStampProvider.get();
        HttpRequest.Builder request = (HttpRequest.Builder)((HttpMessage.Builder)((HttpRequest.Builder)HttpRequest.builder().method(method)).endpoint(Uris.uriBuilder(this.storageUrl).appendPath(container).appendPath(name).build())).replaceHeader("Date", nowString);
        request = this.setHeaders(request, method, options, contentLength, contentType);
        return request.build();
    }

    public HttpRequest sign(String method, String container, String name, @Nullable GetOptions options, long expires, @Nullable Long contentLength, @Nullable String contentType) {
        if (this.authType == AuthType.AZURE_AD) {
            return this.signAD(method, container, name, options, expires, contentLength, contentType);
        }
        if (this.isSAS) {
            return this.signSAS(method, container, name, options, expires, contentLength, contentType);
        }
        return this.signKey(method, container, name, options, expires, contentLength, contentType);
    }
}

