/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.blobstore.functions;

import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.azureblob.domain.ContainerProperties;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.internal.MutableStorageMetadataImpl;
import org.jclouds.domain.Location;

@Singleton
public class ContainerToResourceMetadata
implements Function<ContainerProperties, StorageMetadata> {
    private Supplier<Location> defaultLocation;

    @Inject
    ContainerToResourceMetadata(Supplier<Location> defaultLocation) {
        this.defaultLocation = defaultLocation;
    }

    @Override
    public StorageMetadata apply(ContainerProperties from) {
        MutableStorageMetadataImpl to = new MutableStorageMetadataImpl();
        to.setName(from.getName());
        to.setLocation(this.defaultLocation.get());
        to.setETag(from.getETag());
        to.setLastModified(from.getLastModified());
        to.setUri(from.getUrl());
        to.setType(StorageType.CONTAINER);
        to.setUserMetadata(from.getMetadata());
        return to;
    }
}

