/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.fallbacks;

import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Throwables;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.Fallback;
import org.jclouds.fallbacks.PropagateIfRetryAfter;
import org.jclouds.http.HttpResponseException;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ResourceNotFoundException;

@Singleton
public final class MapHttp4xxCodesToExceptions
implements Fallback<Object> {
    private final PropagateIfRetryAfter propagateIfRetryAfter;

    @Inject
    MapHttp4xxCodesToExceptions(PropagateIfRetryAfter propagateIfRetryAfter) {
        this.propagateIfRetryAfter = Preconditions.checkNotNull(propagateIfRetryAfter, "propagateIfRetryAfter");
    }

    @Override
    public Object createOrPropagate(Throwable t) throws Exception {
        HttpResponseException responseException;
        this.propagateIfRetryAfter.createOrPropagate(t);
        if (t instanceof HttpResponseException && (responseException = (HttpResponseException)HttpResponseException.class.cast(t)).getResponse() != null) {
            switch (responseException.getResponse().getStatusCode()) {
                case 401: {
                    throw new AuthorizationException(responseException);
                }
                case 403: {
                    throw new AuthorizationException(responseException);
                }
                case 404: {
                    throw new ResourceNotFoundException(responseException);
                }
                case 409: {
                    throw new IllegalStateException(responseException);
                }
            }
        }
        throw Throwables.propagate(t);
    }
}

