/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier.filters;

import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.javax.annotation.Resource;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.apache.pulsar.jcloud.shade.javax.inject.Named;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.crypto.Crypto;
import org.jclouds.date.TimeStamp;
import org.jclouds.domain.Credentials;
import org.jclouds.glacier.util.AWSRequestSignerV4;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.HttpUtils;
import org.jclouds.location.Provider;
import org.jclouds.logging.Logger;

@Singleton
public class RequestAuthorizeSignature
implements HttpRequestFilter {
    private final AWSRequestSignerV4 signer;
    @Resource
    @Named(value="jclouds.signature")
    Logger signatureLog = Logger.NULL;
    private final org.apache.pulsar.jcloud.shade.javax.inject.Provider<String> timeStampProvider;
    private final HttpUtils utils;

    @Inject
    public RequestAuthorizeSignature(@TimeStamp org.apache.pulsar.jcloud.shade.javax.inject.Provider<String> timeStampProvider, @Provider Supplier<Credentials> creds, Crypto crypto, HttpUtils utils) {
        Preconditions.checkNotNull(creds, "creds");
        this.signer = new AWSRequestSignerV4(creds.get().identity, creds.get().credential, Preconditions.checkNotNull(crypto, "crypto"));
        this.timeStampProvider = Preconditions.checkNotNull(timeStampProvider, "timeStampProvider");
        this.utils = Preconditions.checkNotNull(utils, "utils");
    }

    @Override
    public HttpRequest filter(HttpRequest request) throws HttpException {
        request = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)request.toBuilder().removeHeader("Date")).replaceHeader("x-amz-date", this.timeStampProvider.get())).replaceHeader("Host", request.getEndpoint().getHost())).build();
        this.utils.logRequest(this.signatureLog, request, ">>");
        request = this.signer.sign(request);
        this.utils.logRequest(this.signatureLog, request, "<<");
        return request;
    }
}

