/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.functions;

import java.util.Set;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Iterables;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.UnwrapOnlyJsonValue;

@Singleton
public class UnwrapOnlyJsonValueInSet<T>
implements Function<HttpResponse, T> {
    private final UnwrapOnlyJsonValue<Set<T>> json;

    @Inject
    UnwrapOnlyJsonValueInSet(UnwrapOnlyJsonValue<Set<T>> json) {
        this.json = json;
    }

    @Override
    public T apply(HttpResponse arg0) {
        Set<T> set = this.json.apply(arg0);
        if (set == null || set.isEmpty()) {
            return null;
        }
        return Iterables.getOnlyElement(set);
    }
}

