/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.functions;

import java.net.URI;
import java.util.Map;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.Provider;
import org.jclouds.location.Region;

public final class RegionToEndpointOrProviderIfNull
implements Function<Object, URI> {
    private final Supplier<URI> defaultUri;
    private final String defaultProvider;
    private final Supplier<Map<String, Supplier<URI>>> regionToEndpointSupplier;

    @Inject
    RegionToEndpointOrProviderIfNull(@Provider String defaultProvider, @Provider Supplier<URI> defaultUri, @Region Supplier<Map<String, Supplier<URI>>> regionToEndpointSupplier) {
        this.defaultProvider = defaultProvider;
        this.defaultUri = defaultUri;
        this.regionToEndpointSupplier = regionToEndpointSupplier;
    }

    @Override
    public URI apply(@Nullable Object from) {
        if (from == null) {
            return this.defaultUri.get();
        }
        Map<String, Supplier<URI>> regionToEndpoint = this.regionToEndpointSupplier.get();
        if (from.equals(this.defaultProvider)) {
            if (regionToEndpoint.containsKey(from)) {
                return regionToEndpoint.get(from).get();
            }
            return this.defaultUri.get();
        }
        Preconditions.checkArgument(regionToEndpoint.containsKey(from), "requested location %s, which is not in the configured locations: %s", from, regionToEndpoint);
        return regionToEndpoint.get(from).get();
    }
}

