/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.suppliers.fromconfig;

import java.util.Set;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Splitter;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableSet;
import org.apache.pulsar.jcloud.shade.com.google.inject.assistedinject.Assisted;
import org.apache.pulsar.jcloud.shade.javax.annotation.Resource;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.config.ValueOfConfigurationKeyOrNull;
import org.jclouds.location.Provider;
import org.jclouds.logging.Logger;

@Singleton
public class SplitConfigurationKey
implements Supplier<Set<String>> {
    @Resource
    protected Logger logger = Logger.NULL;
    protected final ValueOfConfigurationKeyOrNull config;
    protected final String provider;
    protected final String configKey;

    public SplitConfigurationKey(ValueOfConfigurationKeyOrNull config, @Provider String provider, @Assisted String configKey) {
        this.config = config;
        this.provider = provider;
        this.configKey = configKey;
    }

    @Override
    public Set<String> get() {
        String regionString = this.config.apply(this.configKey);
        if (regionString == null) {
            this.logger.debug("no %s configured for provider %s", this.configKey, this.provider);
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf(Splitter.on(',').split(regionString));
    }

    public String toString() {
        return "splitConfigurationKey(" + this.configKey + ")";
    }
}

