/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.suppliers.implicit;

import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Iterables;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.location.functions.ToIdAndScope;
import org.jclouds.location.predicates.LocationPredicates;
import org.jclouds.location.suppliers.ImplicitLocationSupplier;

@Singleton
public class OnlyLocationOrFirstZone
implements ImplicitLocationSupplier {
    private final Supplier<Set<? extends Location>> locationsSupplier;

    @Inject
    OnlyLocationOrFirstZone(@Memoized Supplier<Set<? extends Location>> locationsSupplier) {
        this.locationsSupplier = Preconditions.checkNotNull(locationsSupplier, "locationsSupplierSupplier");
    }

    @Override
    public Location get() {
        Set<? extends Location> locations = this.locationsSupplier.get();
        if (locations.size() == 1) {
            return Iterables.getOnlyElement(locations);
        }
        try {
            return Iterables.find(locations, LocationPredicates.isZone());
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException("none to of the locations are scope ZONE: " + Iterables.transform(locations, ToIdAndScope.INSTANCE));
        }
    }
}

