/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.options;

import java.util.Map;
import org.apache.pulsar.jcloud.shade.com.google.common.base.MoreObjects;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Objects;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableMap;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;

public class CreateTenantOptions
implements MapBinder {
    @Inject
    private BindToJsonPayload jsonBinder;
    private String description;
    private boolean enabled;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CreateTenantOptions) {
            CreateTenantOptions other = (CreateTenantOptions)CreateTenantOptions.class.cast(object);
            return Objects.equal(this.description, other.description) && Objects.equal(this.enabled, other.enabled);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.description, this.enabled);
    }

    protected MoreObjects.ToStringHelper string() {
        MoreObjects.ToStringHelper toString = MoreObjects.toStringHelper("").omitNullValues();
        toString.add("description", this.description);
        toString.add("enabled", (Object)this.enabled);
        return toString;
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        ServerRequest tenant = new ServerRequest(Preconditions.checkNotNull(postParams.get("name"), "name parameter not present").toString());
        if (this.description != null) {
            tenant.description = this.description;
        }
        tenant.enabled = this.enabled;
        return this.bindToRequest(request, ImmutableMap.of("tenant", tenant));
    }

    public String getDescription() {
        return this.description;
    }

    public CreateTenantOptions description(String description) {
        this.description = description;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public CreateTenantOptions enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        return this.jsonBinder.bindToRequest(request, input);
    }

    public static class Builder {
        public static CreateTenantOptions description(String description) {
            CreateTenantOptions options = new CreateTenantOptions();
            return options.description(description);
        }

        public static CreateTenantOptions enabled(boolean enabled) {
            CreateTenantOptions options = new CreateTenantOptions();
            return options.enabled(enabled);
        }
    }

    static class ServerRequest {
        final String name;
        String description;
        boolean enabled;

        private ServerRequest(String name) {
            this.name = name;
        }
    }
}

