/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.options;

import java.util.Map;
import org.apache.pulsar.jcloud.shade.com.google.common.base.MoreObjects;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Objects;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableMap;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;

public class UpdateTenantOptions
implements MapBinder {
    @Inject
    private BindToJsonPayload jsonBinder;
    private String name;
    private String description;
    private boolean enabled;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof UpdateTenantOptions) {
            UpdateTenantOptions other = (UpdateTenantOptions)UpdateTenantOptions.class.cast(object);
            return Objects.equal(this.description, other.description) && Objects.equal(this.enabled, other.enabled) && Objects.equal(this.name, other.name);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.name, this.description, this.enabled);
    }

    protected MoreObjects.ToStringHelper string() {
        MoreObjects.ToStringHelper toString = MoreObjects.toStringHelper("").omitNullValues();
        toString.add("name", this.name);
        toString.add("description", this.description);
        toString.add("enabled", (Object)this.enabled);
        return toString;
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        ServerRequest tenant = new ServerRequest();
        if (this.description != null) {
            tenant.description = this.description;
        }
        if (this.name != null) {
            tenant.name = this.name;
        }
        tenant.enabled = this.enabled;
        return this.bindToRequest(request, ImmutableMap.of("tenant", tenant));
    }

    public String getDescription() {
        return this.description;
    }

    public UpdateTenantOptions description(String description) {
        this.description = description;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public UpdateTenantOptions enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public UpdateTenantOptions name(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        return this.jsonBinder.bindToRequest(request, input);
    }

    public static class Builder {
        public static UpdateTenantOptions name(String name) {
            UpdateTenantOptions options = new UpdateTenantOptions();
            return options.name(name);
        }

        public static UpdateTenantOptions description(String description) {
            UpdateTenantOptions options = new UpdateTenantOptions();
            return options.description(description);
        }

        public static UpdateTenantOptions enabled(boolean enabled) {
            UpdateTenantOptions options = new UpdateTenantOptions();
            return options.enabled(enabled);
        }
    }

    static class ServerRequest {
        String name;
        String description;
        boolean enabled;

        ServerRequest() {
        }
    }
}

