/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.blobstore.functions;

import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.s3.blobstore.functions.ObjectToBlobMetadata;
import org.jclouds.s3.domain.S3Object;

@Singleton
public class ObjectToBlob
implements Function<S3Object, Blob> {
    private final Blob.Factory blobFactory;
    private final ObjectToBlobMetadata object2BlobMd;

    @Inject
    ObjectToBlob(Blob.Factory blobFactory, ObjectToBlobMetadata object2BlobMd) {
        this.blobFactory = blobFactory;
        this.object2BlobMd = object2BlobMd;
    }

    @Override
    public Blob apply(S3Object from) {
        if (from == null) {
            return null;
        }
        Blob blob = this.blobFactory.create(this.object2BlobMd.apply(from.getMetadata()));
        blob.setPayload(Preconditions.checkNotNull(from.getPayload(), "payload: " + from));
        blob.setAllHeaders(from.getAllHeaders());
        return blob;
    }
}

