/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.filters;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.util.Date;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Joiner;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Strings;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableMap;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableSortedMap;
import org.apache.pulsar.jcloud.shade.com.google.common.hash.HashCode;
import org.apache.pulsar.jcloud.shade.com.google.common.io.BaseEncoding;
import org.apache.pulsar.jcloud.shade.com.google.common.io.ByteProcessor;
import org.apache.pulsar.jcloud.shade.com.google.common.io.ByteStreams;
import org.apache.pulsar.jcloud.shade.com.google.inject.Inject;
import org.apache.pulsar.jcloud.shade.javax.inject.Named;
import org.jclouds.aws.domain.SessionCredentials;
import org.jclouds.crypto.Crypto;
import org.jclouds.date.TimeStamp;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.internal.SignatureWire;
import org.jclouds.io.Payload;
import org.jclouds.location.Provider;
import org.jclouds.s3.filters.Aws4SignerBase;
import org.jclouds.s3.filters.ChunkedUploadException;
import org.jclouds.s3.filters.ChunkedUploadPayload;
import org.jclouds.util.Strings2;

public class Aws4SignerForChunkedUpload
extends Aws4SignerBase {
    private final int userDataBlockSize;

    @Inject
    public Aws4SignerForChunkedUpload(SignatureWire signatureWire, @Named(value="jclouds.aws.header.tag") String headerTag, @Named(value="jclouds.s3.chunked.size") int userDataBlockSize, @Provider Supplier<Credentials> creds, @TimeStamp Supplier<Date> timestampProvider, Aws4SignerBase.ServiceAndRegion serviceAndRegion, Crypto crypto) {
        super(signatureWire, headerTag, creds, timestampProvider, serviceAndRegion, crypto);
        this.userDataBlockSize = userDataBlockSize;
    }

    protected HttpRequest sign(HttpRequest request) throws HttpException {
        String signature;
        ByteProcessor<byte[]> hmacSHA256;
        String contentType;
        HashCode md5;
        Preconditions.checkNotNull(request, "request is not ready to sign");
        Preconditions.checkNotNull(request.getEndpoint(), "request is not ready to sign, request.endpoint not present.");
        Payload payload = request.getPayload();
        Long contentLength = payload.getContentMetadata().getContentLength();
        Preconditions.checkNotNull(contentLength, "request is not ready to sign, payload contentLength not present.");
        String host = request.getEndpoint().getHost();
        Date date = (Date)this.timestampProvider.get();
        String timestamp = this.timestampFormat.format(date);
        String datestamp = this.dateFormat.format(date);
        String service = this.serviceAndRegion.service();
        String region = this.serviceAndRegion.region(host);
        String credentialScope = Joiner.on('/').join(datestamp, region, service, "aws4_request");
        HttpRequest.Builder requestBuilder = (HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)request.toBuilder().removeHeader("Authorization")).removeHeader("Date")).removeHeader("Content-Length");
        ImmutableSortedMap.Builder<String, String> signedHeadersBuilder = ImmutableSortedMap.naturalOrder();
        String contentEncoding = "aws-chunked";
        String originalContentEncoding = payload.getContentMetadata().getContentEncoding();
        if (originalContentEncoding != null) {
            contentEncoding = contentEncoding + "," + originalContentEncoding;
        }
        requestBuilder.replaceHeader("Content-Encoding", contentEncoding);
        ((ImmutableMap.Builder)signedHeadersBuilder).put("Content-Encoding".toLowerCase(), contentEncoding);
        requestBuilder.replaceHeader("x-amz-decoded-content-length", contentLength.toString());
        ((ImmutableMap.Builder)signedHeadersBuilder).put("x-amz-decoded-content-length".toLowerCase(), contentLength.toString());
        long totalLength = Aws4SignerForChunkedUpload.calculateChunkedContentLength(contentLength, this.userDataBlockSize);
        requestBuilder.replaceHeader("Content-Length", Long.toString(totalLength));
        ((ImmutableMap.Builder)signedHeadersBuilder).put("Content-Length".toLowerCase(), Long.toString(totalLength));
        String contentMD5 = request.getFirstHeaderOrNull("Content-MD5");
        if (payload != null && (md5 = payload.getContentMetadata().getContentMD5AsHashCode()) != null) {
            contentMD5 = BaseEncoding.base64().encode(md5.asBytes());
        }
        if (contentMD5 != null) {
            requestBuilder.replaceHeader("Content-MD5", contentMD5);
            ((ImmutableMap.Builder)signedHeadersBuilder).put("Content-MD5".toLowerCase(), contentMD5);
        }
        if (!Strings.isNullOrEmpty(contentType = this.getContentType(request))) {
            requestBuilder.replaceHeader("Content-Type", contentType);
            ((ImmutableMap.Builder)signedHeadersBuilder).put("Content-Type".toLowerCase(), contentType);
        } else {
            requestBuilder.removeHeader("Content-Type");
        }
        host = Aws4SignerForChunkedUpload.hostHeaderFor(request.getEndpoint());
        requestBuilder.replaceHeader("Host", host);
        ((ImmutableMap.Builder)signedHeadersBuilder).put("Host".toLowerCase(), host);
        String userAgent = request.getFirstHeaderOrNull("User-Agent");
        if (userAgent != null) {
            ((ImmutableMap.Builder)signedHeadersBuilder).put("User-Agent".toLowerCase(), userAgent);
        }
        this.appendAmzHeaders(request, signedHeadersBuilder);
        Credentials credentials = (Credentials)this.creds.get();
        if (credentials instanceof SessionCredentials) {
            String token = ((SessionCredentials)SessionCredentials.class.cast(credentials)).getSessionToken();
            requestBuilder.replaceHeader("X-Amz-Security-Token", token);
            ((ImmutableMap.Builder)signedHeadersBuilder).put("X-Amz-Security-Token".toLowerCase(), token);
        }
        String contentSha256 = this.getPayloadHash();
        requestBuilder.replaceHeader("x-amz-content-sha256", contentSha256);
        ((ImmutableMap.Builder)signedHeadersBuilder).put("x-amz-content-sha256".toLowerCase(), contentSha256);
        requestBuilder.replaceHeader("X-Amz-Date", timestamp);
        ((ImmutableMap.Builder)signedHeadersBuilder).put("X-Amz-Date".toLowerCase(), timestamp);
        ImmutableMap<String, String> signedHeaders = ((ImmutableMap.Builder)signedHeadersBuilder).build();
        String stringToSign = this.createStringToSign(request.getMethod(), request.getEndpoint(), signedHeaders, timestamp, credentialScope, contentSha256);
        this.signatureWire.getWireLog().debug("<< " + stringToSign, new Object[0]);
        byte[] signatureKey = this.signatureKey(credentials.credential, datestamp, region, service);
        try {
            hmacSHA256 = Aws4SignerForChunkedUpload.hmacSHA256(this.crypto, signatureKey);
        }
        catch (InvalidKeyException e) {
            throw new ChunkedUploadException("invalid key", e);
        }
        try {
            signature = Aws4SignerForChunkedUpload.hex(ByteStreams.readBytes(Strings2.toInputStream(stringToSign), hmacSHA256));
        }
        catch (IOException e) {
            throw new ChunkedUploadException("hmac sha256 seed signature error", e);
        }
        StringBuilder authorization = new StringBuilder("AWS4-HMAC-SHA256").append(" ");
        authorization.append("Credential=").append(Joiner.on("/").join(credentials.identity, credentialScope, new Object[0])).append(", ");
        authorization.append("SignedHeaders=").append(Joiner.on(";").join(signedHeaders.keySet())).append(", ");
        authorization.append("Signature=").append(signature);
        ChunkedUploadPayload chunkedPayload = new ChunkedUploadPayload(payload, this.userDataBlockSize, timestamp, credentialScope, hmacSHA256, signature);
        chunkedPayload.getContentMetadata().setContentEncoding(null);
        return ((HttpRequest.Builder)((HttpRequest.Builder)requestBuilder.replaceHeader("Authorization", authorization.toString())).payload(chunkedPayload)).build();
    }

    protected String getPayloadHash() {
        return "STREAMING-AWS4-HMAC-SHA256-PAYLOAD";
    }

    public static long calculateChunkedContentLength(long originalLength, long chunkSize) {
        Preconditions.checkArgument(originalLength > 0L, "Nonnegative content length expected.");
        long maxSizeChunks = originalLength / chunkSize;
        long remainingBytes = originalLength % chunkSize;
        return maxSizeChunks * Aws4SignerForChunkedUpload.calculateChunkHeaderLength(chunkSize) + (remainingBytes > 0L ? Aws4SignerForChunkedUpload.calculateChunkHeaderLength(remainingBytes) : 0L) + Aws4SignerForChunkedUpload.calculateChunkHeaderLength(0L);
    }

    private static long calculateChunkHeaderLength(long chunkDataSize) {
        return (long)(Long.toHexString(chunkDataSize).length() + ";chunk-signature=".length() + 64 + "\r\n".length()) + chunkDataSize + (long)"\r\n".length();
    }
}

