/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.functions;

import java.net.URI;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Optional;
import org.apache.pulsar.jcloud.shade.com.google.common.cache.LoadingCache;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.s3.Bucket;
import org.jclouds.s3.functions.AssignCorrectHostnameForBucket;

public final class DefaultEndpointThenInvalidateRegion
implements Function<Object, URI> {
    private final Function<Object, URI> delegate;
    private final LoadingCache<String, Optional<String>> bucketToRegionCache;

    @Inject
    DefaultEndpointThenInvalidateRegion(AssignCorrectHostnameForBucket delegate, @Bucket LoadingCache<String, Optional<String>> bucketToRegionCache) {
        this.delegate = delegate;
        this.bucketToRegionCache = bucketToRegionCache;
    }

    @Override
    public URI apply(@Nullable Object from) {
        try {
            URI uRI = this.delegate.apply(from);
            return uRI;
        }
        finally {
            this.bucketToRegionCache.invalidate(from.toString());
        }
    }
}

