/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.filters;

import java.net.URI;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableMap;

public class AwsHostNameUtils {
    private static final Pattern S3_ENDPOINT_PATTERN = Pattern.compile("^(?:.+\\.)?s3[.-]([a-z0-9-]+)$");
    private static final Pattern STANDARD_CLOUDSEARCH_ENDPOINT_PATTERN = Pattern.compile("^(?:.+\\.)?([a-z0-9-]+)\\.cloudsearch$");
    private static final Pattern EXTENDED_CLOUDSEARCH_ENDPOINT_PATTERN = Pattern.compile("^(?:.+\\.)?([a-z0-9-]+)\\.cloudsearch\\..+");
    private static final ImmutableMap<String, String> HOST_REGEX_TO_REGION_MAPPINGS = new ImmutableMap.Builder<String, String>().put("(.+\\.)?s3\\.amazonaws\\.com", "us-east-1").put("(.+\\.)?s3-external-1\\.amazonaws\\.com", "us-east-1").put("(.+\\.)?s3-fips-us-gov-west-1\\.amazonaws\\.com", "us-gov-west-1").build();

    public static String parseRegionName(String host, String serviceHint) {
        String regionNameInInternalConfig = AwsHostNameUtils.parseRegionNameByInternalConfig(host);
        if (regionNameInInternalConfig != null) {
            return regionNameInInternalConfig;
        }
        if (host.endsWith(".amazonaws.com")) {
            int index = host.length() - ".amazonaws.com".length();
            return AwsHostNameUtils.parseStandardRegionName(host.substring(0, index));
        }
        if (serviceHint != null) {
            Matcher matcher;
            if (serviceHint.equals("cloudsearch") && !host.startsWith("cloudsearch.") && (matcher = EXTENDED_CLOUDSEARCH_ENDPOINT_PATTERN.matcher(host)).matches()) {
                return matcher.group(1);
            }
            Pattern pattern = Pattern.compile("^(?:.+\\.)?" + Pattern.quote(serviceHint) + "[.-]([a-z0-9-]+)\\.");
            Matcher matcher2 = pattern.matcher(host);
            if (matcher2.find()) {
                return matcher2.group(1);
            }
        }
        return "us-east-1";
    }

    private static String parseStandardRegionName(String fragment) {
        Matcher matcher = S3_ENDPOINT_PATTERN.matcher(fragment);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        matcher = STANDARD_CLOUDSEARCH_ENDPOINT_PATTERN.matcher(fragment);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        int index = fragment.lastIndexOf(46);
        if (index == -1) {
            return "us-east-1";
        }
        String region = fragment.substring(index + 1);
        if ("us-gov".equals(region)) {
            region = "us-gov-west-1";
        }
        return region;
    }

    private static String parseRegionNameByInternalConfig(String host) {
        for (Map.Entry mapping : HOST_REGEX_TO_REGION_MAPPINGS.entrySet()) {
            String hostNameRegex = (String)mapping.getKey();
            if (!host.matches(hostNameRegex)) continue;
            return (String)mapping.getValue();
        }
        return null;
    }

    public static String parseServiceName(URI endpoint) {
        String host = endpoint.getHost();
        if (!host.endsWith(".amazonaws.com") && !host.endsWith(".amazonaws.com.cn")) {
            return "s3";
        }
        String serviceAndRegion = host.substring(0, host.indexOf(".amazonaws.com"));
        if (serviceAndRegion.endsWith(".s3") || S3_ENDPOINT_PATTERN.matcher(serviceAndRegion).matches()) {
            return "s3";
        }
        int separator = 46;
        if (serviceAndRegion.indexOf(separator) == -1) {
            return serviceAndRegion;
        }
        return serviceAndRegion.substring(0, serviceAndRegion.indexOf(separator));
    }
}

