/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.xml;

import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.jclouds.aws.domain.SessionCredentials;
import org.jclouds.date.DateService;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;

public class SessionCredentialsHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<SessionCredentials> {
    private final DateService dateService;
    private StringBuilder currentText = new StringBuilder();
    private SessionCredentials.Builder builder = SessionCredentials.builder();

    @Inject
    protected SessionCredentialsHandler(DateService dateService) {
        this.dateService = dateService;
    }

    @Override
    public SessionCredentials getResult() {
        try {
            SessionCredentials sessionCredentials = this.builder.build();
            return sessionCredentials;
        }
        finally {
            this.builder = SessionCredentials.builder();
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (qName.equals("AccessKeyId")) {
            this.builder.accessKeyId(SaxUtils.currentOrNull(this.currentText));
        } else if (qName.equals("SecretAccessKey")) {
            this.builder.secretAccessKey(SaxUtils.currentOrNull(this.currentText));
        } else if (qName.equals("SessionToken")) {
            this.builder.sessionToken(SaxUtils.currentOrNull(this.currentText));
        } else if (qName.equals("Expiration")) {
            try {
                this.builder.expiration(this.dateService.iso8601SecondsDateParse(SaxUtils.currentOrNull(this.currentText)));
            }
            catch (IllegalArgumentException e) {
                this.builder.expiration(this.dateService.iso8601DateParse(SaxUtils.currentOrNull(this.currentText)));
            }
        }
        this.currentText.setLength(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

