/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier.blobstore.strategy.internal;

import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableMap;
import org.apache.pulsar.jcloud.shade.com.google.common.hash.HashCode;
import org.apache.pulsar.jcloud.shade.com.google.inject.Inject;
import org.apache.pulsar.jcloud.shade.com.google.inject.Singleton;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.glacier.GlacierClient;
import org.jclouds.glacier.blobstore.strategy.MultipartUploadStrategy;
import org.jclouds.glacier.blobstore.strategy.PayloadSlice;
import org.jclouds.glacier.blobstore.strategy.SlicingStrategy;

@Singleton
public class SequentialMultipartUploadStrategy
implements MultipartUploadStrategy {
    private final GlacierClient client;
    private final SlicingStrategy slicer;

    @Inject
    public SequentialMultipartUploadStrategy(GlacierClient client, SlicingStrategy slicer) {
        this.client = Preconditions.checkNotNull(client, "client");
        this.slicer = Preconditions.checkNotNull(slicer, "slicer");
    }

    @Override
    public String execute(String container, Blob blob) {
        this.slicer.startSlicing(blob.getPayload());
        String uploadId = this.client.initiateMultipartUpload(container, this.slicer.getPartSizeInMB(), blob.getMetadata().getName());
        try {
            ImmutableMap.Builder<Integer, HashCode> hashes = ImmutableMap.builder();
            while (this.slicer.hasNext()) {
                PayloadSlice slice = this.slicer.nextSlice();
                hashes.put(slice.getPart(), this.client.uploadPart(container, uploadId, slice.getRange(), slice.getPayload()));
            }
            return this.client.completeMultipartUpload(container, uploadId, hashes.build(), blob.getPayload().getContentMetadata().getContentLength());
        }
        catch (RuntimeException exception) {
            this.client.abortMultipartUpload(container, uploadId);
            throw exception;
        }
    }
}

