/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier.predicates.validators;

import org.apache.pulsar.jcloud.shade.com.google.common.base.CharMatcher;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Strings;
import org.apache.pulsar.jcloud.shade.com.google.inject.Singleton;
import org.jclouds.predicates.Validator;

@Singleton
public final class DescriptionValidator
extends Validator<String> {
    private static final int MAX_DESC_LENGTH = 1024;
    private static final CharMatcher DESCRIPTION_ACCEPTABLE_RANGE = CharMatcher.inRange(' ', '~');

    @Override
    public void validate(String description) {
        if (Strings.isNullOrEmpty(description)) {
            return;
        }
        Preconditions.checkArgument(description.length() <= 1024, "Description can't be longer than %s characters but was %s", 1024, description.length());
        Preconditions.checkArgument(DESCRIPTION_ACCEPTABLE_RANGE.matchesAllOf(description), "Description should have ASCII values between 32 and 126.");
    }
}

