/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier.domain;

import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.Iterator;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.FluentIterable;
import org.apache.pulsar.jcloud.shade.com.google.gson.annotations.SerializedName;
import org.jclouds.glacier.domain.ArchiveMetadata;

public class ArchiveMetadataCollection
extends FluentIterable<ArchiveMetadata> {
    @SerializedName(value="ArchiveList")
    private final Iterable<ArchiveMetadata> archives;
    @SerializedName(value="VaultARN")
    private final String vaultARN;
    @SerializedName(value="InventoryDate")
    private final Date inventoryDate;

    @ConstructorProperties(value={"ArchiveList", "VaultARN", "InventoryDate"})
    public ArchiveMetadataCollection(Iterable<ArchiveMetadata> archives, String vaultARN, Date inventoryDate) {
        this.archives = Preconditions.checkNotNull(archives, "archives");
        this.vaultARN = Preconditions.checkNotNull(vaultARN, "vaultARN");
        this.inventoryDate = (Date)Preconditions.checkNotNull(inventoryDate, "inventoryDate").clone();
    }

    @Override
    public Iterator<ArchiveMetadata> iterator() {
        return this.archives.iterator();
    }

    public String getVaultARN() {
        return this.vaultARN;
    }

    public Date getInventoryDate() {
        return (Date)this.inventoryDate.clone();
    }
}

