/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudfiles.v1.functions;

import java.net.URI;
import java.util.Map;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Singleton;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.suppliers.RegionIdToURISupplier;
import org.jclouds.rest.annotations.ApiVersion;

@Singleton
public class RegionToCDNEndpoint
implements Function<Object, URI> {
    private final Supplier<Map<String, Supplier<URI>>> endpointsSupplier;

    @Inject
    public RegionToCDNEndpoint(@ApiVersion String apiVersion, RegionIdToURISupplier.Factory factory) {
        this.endpointsSupplier = factory.createForApiTypeAndVersion("rax:object-cdn", apiVersion);
    }

    @Override
    public URI apply(@Nullable Object from) {
        Preconditions.checkArgument(from != null && from instanceof String, "you must specify a region, as a String argument");
        Map<String, Supplier<URI>> regionToEndpoint = this.endpointsSupplier.get();
        Preconditions.checkState(!regionToEndpoint.isEmpty(), "no region name to endpoint mappings configured!");
        Preconditions.checkArgument(regionToEndpoint.containsKey(from), "requested location %s, which is not in the configured locations: %s", from, regionToEndpoint);
        return regionToEndpoint.get(from).get();
    }
}

