/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.filters;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Enumeration;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Charsets;
import org.apache.pulsar.jcloud.shade.com.google.common.io.ByteProcessor;
import org.apache.pulsar.jcloud.shade.com.google.common.io.ByteStreams;
import org.jclouds.http.HttpException;
import org.jclouds.io.Payload;
import org.jclouds.io.payloads.BaseMutableContentMetadata;
import org.jclouds.io.payloads.BasePayload;
import org.jclouds.s3.filters.Aws4SignerBase;
import org.jclouds.s3.filters.Aws4SignerForChunkedUpload;
import org.jclouds.s3.filters.AwsSignatureV4Constants;
import org.jclouds.s3.filters.ChunkedUploadException;
import org.jclouds.util.Strings2;

public class ChunkedUploadPayload
extends BasePayload<Payload> {
    private static final byte[] TRAILER = "\r\n".getBytes(Charsets.UTF_8);
    private final Payload payload;
    private final int chunkedBlockSize;
    private final String timestamp;
    private final String scope;
    private final ByteProcessor<byte[]> hmacSHA256;
    private String lastComputedSignature;

    public ChunkedUploadPayload(Payload payload, int blockSize, String timestamp, String scope, ByteProcessor<byte[]> hmacSHA256, String seedSignature) {
        super(payload);
        this.payload = payload;
        this.chunkedBlockSize = blockSize;
        this.timestamp = timestamp;
        this.scope = scope;
        this.hmacSHA256 = hmacSHA256;
        this.lastComputedSignature = seedSignature;
        BaseMutableContentMetadata contentMetadata = BaseMutableContentMetadata.fromContentMetadata(payload.getContentMetadata());
        long totalLength = Aws4SignerForChunkedUpload.calculateChunkedContentLength(payload.getContentMetadata().getContentLength(), this.chunkedBlockSize);
        contentMetadata.setContentLength(totalLength);
        this.setContentMetadata(contentMetadata);
    }

    protected byte[] constructSignedChunk(int userDataLen, byte[] userData) {
        String chunkSignature;
        byte[] dataToChunk;
        if (userDataLen == 0) {
            dataToChunk = AwsSignatureV4Constants.FINAL_CHUNK;
        } else if (userDataLen < userData.length) {
            dataToChunk = new byte[userDataLen];
            System.arraycopy(userData, 0, dataToChunk, 0, userDataLen);
        } else {
            dataToChunk = userData;
        }
        StringBuilder chunkHeader = new StringBuilder();
        chunkHeader.append(Integer.toHexString(dataToChunk.length));
        String nonsigExtension = "";
        StringBuilder buffer = new StringBuilder();
        buffer.append("AWS4-HMAC-SHA256-PAYLOAD");
        buffer.append("\n");
        buffer.append(this.timestamp).append("\n");
        buffer.append(this.scope).append("\n");
        buffer.append(this.lastComputedSignature).append("\n");
        buffer.append(Aws4SignerBase.hex(Aws4SignerBase.hash(nonsigExtension))).append("\n");
        buffer.append(Aws4SignerBase.hex(Aws4SignerBase.hash(dataToChunk)));
        String chunkStringToSign = buffer.toString();
        try {
            chunkSignature = Aws4SignerBase.hex(ByteStreams.readBytes(Strings2.toInputStream(chunkStringToSign), this.hmacSHA256));
        }
        catch (IOException e) {
            throw new HttpException("hmac sha256 chunked signature error");
        }
        this.lastComputedSignature = chunkSignature;
        chunkHeader.append(nonsigExtension + ";chunk-signature=" + chunkSignature);
        chunkHeader.append("\r\n");
        byte[] header = chunkHeader.toString().getBytes(Charsets.UTF_8);
        byte[] signedChunk = new byte[header.length + dataToChunk.length + TRAILER.length];
        System.arraycopy(header, 0, signedChunk, 0, header.length);
        System.arraycopy(dataToChunk, 0, signedChunk, header.length, dataToChunk.length);
        System.arraycopy(TRAILER, 0, signedChunk, header.length + dataToChunk.length, TRAILER.length);
        return signedChunk;
    }

    @Override
    public void release() {
        this.payload.release();
    }

    @Override
    public boolean isRepeatable() {
        return this.payload.isRepeatable();
    }

    @Override
    public InputStream openStream() throws IOException {
        return new SequenceInputStream(new ChunkedInputStreamEnumeration(this.payload.openStream(), this.chunkedBlockSize));
    }

    private class ChunkedInputStreamEnumeration
    implements Enumeration<InputStream> {
        private final InputStream inputStream;
        private boolean lastChunked;
        private byte[] buffer;

        ChunkedInputStreamEnumeration(InputStream inputStream, int chunkedBlockSize) {
            this.inputStream = new BufferedInputStream(inputStream, chunkedBlockSize);
            this.buffer = new byte[chunkedBlockSize];
            this.lastChunked = false;
        }

        @Override
        public boolean hasMoreElements() {
            return !this.lastChunked;
        }

        @Override
        public InputStream nextElement() {
            byte[] chunk;
            int bytesRead;
            try {
                bytesRead = ByteStreams.read(this.inputStream, this.buffer, 0, this.buffer.length);
            }
            catch (IOException e) {
                throw new ChunkedUploadException("read from input stream error", e);
            }
            if (bytesRead > 0) {
                chunk = ChunkedUploadPayload.this.constructSignedChunk(bytesRead, this.buffer);
            } else {
                chunk = ChunkedUploadPayload.this.constructSignedChunk(0, this.buffer);
                this.lastChunked = true;
            }
            return new ByteArrayInputStream(chunk);
        }
    }
}

