/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sts.options;

import org.apache.pulsar.jcloud.shade.com.google.common.base.MoreObjects;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Objects;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Multimap;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class AssumeRoleOptions
extends BaseHttpRequestOptions
implements Cloneable {
    private Long durationSeconds;
    private String policy;
    private String externalId;

    public AssumeRoleOptions externalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    public AssumeRoleOptions durationSeconds(long durationSeconds) {
        this.durationSeconds = durationSeconds;
        return this;
    }

    public AssumeRoleOptions policy(String policy) {
        this.policy = policy;
        return this;
    }

    @Override
    public Multimap<String, String> buildFormParameters() {
        Multimap<String, String> params = super.buildFormParameters();
        if (this.externalId != null) {
            params.put("ExternalId", this.externalId.toString());
        }
        if (this.durationSeconds != null) {
            params.put("DurationSeconds", this.durationSeconds.toString());
        }
        if (this.policy != null) {
            params.put("Policy", this.policy);
        }
        return params;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.externalId, this.durationSeconds, this.policy);
    }

    public AssumeRoleOptions clone() {
        return new AssumeRoleOptions().externalId(this.externalId).durationSeconds(this.durationSeconds).policy(this.policy);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AssumeRoleOptions other = (AssumeRoleOptions)AssumeRoleOptions.class.cast(obj);
        return Objects.equal(this.externalId, other.externalId) && Objects.equal(this.durationSeconds, other.durationSeconds) && Objects.equal(this.policy, other.policy);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("externalId", this.externalId).add("durationSeconds", this.durationSeconds).add("policy", this.policy).toString();
    }

    public static class Builder {
        public static AssumeRoleOptions externalId(String externalId) {
            return new AssumeRoleOptions().externalId(externalId);
        }

        public static AssumeRoleOptions durationSeconds(long durationSeconds) {
            return new AssumeRoleOptions().durationSeconds(durationSeconds);
        }

        public static AssumeRoleOptions policy(String policy) {
            return new AssumeRoleOptions().policy(policy);
        }
    }
}

