/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.authentication;

import javax.naming.AuthenticationException;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authentication.PulsarSaslServer;
import org.apache.pulsar.common.api.AuthData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslAuthenticationDataSource
implements AuthenticationDataSource {
    private static final Logger log = LoggerFactory.getLogger(SaslAuthenticationDataSource.class);
    private static final long serialVersionUID = 1L;
    protected AuthData serverSideToken;
    private PulsarSaslServer pulsarSaslServer;

    public SaslAuthenticationDataSource(PulsarSaslServer saslServer) {
        this.pulsarSaslServer = saslServer;
    }

    public boolean hasDataFromCommand() {
        return true;
    }

    public AuthData authenticate(AuthData data) throws AuthenticationException {
        this.serverSideToken = this.pulsarSaslServer.response(data);
        return this.serverSideToken;
    }

    public boolean isComplete() {
        return this.pulsarSaslServer.isComplete();
    }

    public String getAuthorizationID() {
        return this.pulsarSaslServer.getAuthorizationID();
    }
}

