/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats.prometheus;

import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.bookkeeper.util.SafeRunnable;
import org.apache.pulsar.broker.stats.prometheus.PrometheusMetricsGeneratorUtils;
import org.apache.pulsar.broker.stats.prometheus.PrometheusRawMetricsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusMetricsServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final int HTTP_STATUS_OK_200 = 200;
    private static final int HTTP_STATUS_INTERNAL_SERVER_ERROR_500 = 500;
    private final long metricsServletTimeoutMs;
    private final String cluster;
    protected List<PrometheusRawMetricsProvider> metricsProviders;
    private ExecutorService executor = null;
    private static final Logger log = LoggerFactory.getLogger(PrometheusMetricsServlet.class);

    public PrometheusMetricsServlet(long metricsServletTimeoutMs, String cluster) {
        this.metricsServletTimeoutMs = metricsServletTimeoutMs;
        this.cluster = cluster;
    }

    public void init() throws ServletException {
        this.executor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("prometheus-stats"));
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        AsyncContext context = request.startAsync();
        context.setTimeout(this.metricsServletTimeoutMs);
        this.executor.execute((Runnable)SafeRunnable.safeRun(() -> {
            long start = System.currentTimeMillis();
            HttpServletResponse res = (HttpServletResponse)context.getResponse();
            try {
                res.setStatus(200);
                res.setContentType("text/plain");
                this.generateMetrics(this.cluster, res.getOutputStream());
            }
            catch (Exception e) {
                long end = System.currentTimeMillis();
                long time = end - start;
                if (e instanceof EOFException) {
                    log.error("Failed to send metrics, likely the client or this server closed the connection due to a timeout ({} ms elapsed): {}", (Object)time, (Object)(e + ""));
                } else {
                    log.error("Failed to generate prometheus stats, {} ms elapsed", (Object)time, (Object)e);
                }
                res.setStatus(500);
            }
            finally {
                long end = System.currentTimeMillis();
                long time = end - start;
                try {
                    context.complete();
                }
                catch (IllegalStateException e) {
                    log.error("Failed to generate prometheus stats, this is likely due to metricsServletTimeoutMs: {} ms elapsed: {}", (Object)time, (Object)(e + ""));
                }
            }
        }));
    }

    protected void generateMetrics(String cluster, ServletOutputStream outputStream) throws IOException {
        PrometheusMetricsGeneratorUtils.generate(cluster, (OutputStream)outputStream, this.metricsProviders);
    }

    public void destroy() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    public void addRawMetricsProvider(PrometheusRawMetricsProvider metricsProvider) {
        if (this.metricsProviders == null) {
            this.metricsProviders = new LinkedList<PrometheusRawMetricsProvider>();
        }
        this.metricsProviders.add(metricsProvider);
    }
}

