/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.resources;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.metadata.api.MetadataCache;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.zookeeper.common.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseResources<T> {
    private static final Logger log = LoggerFactory.getLogger(BaseResources.class);
    protected static final String BASE_POLICIES_PATH = "/admin/policies";
    protected static final String BASE_CLUSTERS_PATH = "/admin/clusters";
    private final MetadataStore store;
    private final MetadataCache<T> cache;
    private int operationTimeoutSec;

    public BaseResources(MetadataStore store, Class<T> clazz, int operationTimeoutSec) {
        this.store = store;
        this.cache = store.getMetadataCache(clazz);
        this.operationTimeoutSec = operationTimeoutSec;
    }

    public BaseResources(MetadataStore store, TypeReference<T> typeRef, int operationTimeoutSec) {
        this.store = store;
        this.cache = store.getMetadataCache(typeRef);
        this.operationTimeoutSec = operationTimeoutSec;
    }

    protected List<String> getChildren(String path) throws MetadataStoreException {
        try {
            return this.getChildrenAsync(path).get(this.operationTimeoutSec, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            throw e.getCause() instanceof MetadataStoreException ? (MetadataStoreException)e.getCause() : new MetadataStoreException(e.getCause());
        }
        catch (Exception e) {
            throw new MetadataStoreException("Failed to get childeren of " + path, (Throwable)e);
        }
    }

    protected CompletableFuture<List<String>> getChildrenAsync(String path) {
        return this.cache.getChildren(path);
    }

    protected Optional<T> get(String path) throws MetadataStoreException {
        try {
            return this.getAsync(path).get(this.operationTimeoutSec, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            throw e.getCause() instanceof MetadataStoreException ? (MetadataStoreException)e.getCause() : new MetadataStoreException(e.getCause());
        }
        catch (Exception e) {
            throw new MetadataStoreException("Failed to get data from " + path, (Throwable)e);
        }
    }

    protected CompletableFuture<Optional<T>> getAsync(String path) {
        return this.cache.get(path);
    }

    protected void set(String path, Function<T, T> modifyFunction) throws MetadataStoreException {
        try {
            this.setAsync(path, modifyFunction).get(this.operationTimeoutSec, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            throw e.getCause() instanceof MetadataStoreException ? (MetadataStoreException)e.getCause() : new MetadataStoreException(e.getCause());
        }
        catch (Exception e) {
            throw new MetadataStoreException("Failed to set data for " + path, (Throwable)e);
        }
    }

    protected CompletableFuture<Void> setAsync(String path, Function<T, T> modifyFunction) {
        return this.cache.readModifyUpdate(path, modifyFunction).thenApply(__ -> null);
    }

    protected void setWithCreate(String path, Function<Optional<T>, T> createFunction) throws MetadataStoreException {
        try {
            this.setWithCreateAsync(path, createFunction).get(this.operationTimeoutSec, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            throw e.getCause() instanceof MetadataStoreException ? (MetadataStoreException)e.getCause() : new MetadataStoreException(e.getCause());
        }
        catch (Exception e) {
            throw new MetadataStoreException("Failed to set/create " + path, (Throwable)e);
        }
    }

    protected CompletableFuture<Void> setWithCreateAsync(String path, Function<Optional<T>, T> createFunction) {
        return this.cache.readModifyUpdateOrCreate(path, createFunction).thenApply(__ -> null);
    }

    protected void create(String path, T data) throws MetadataStoreException {
        try {
            this.createAsync(path, data).get(this.operationTimeoutSec, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            throw e.getCause() instanceof MetadataStoreException ? (MetadataStoreException)e.getCause() : new MetadataStoreException(e.getCause());
        }
        catch (Exception e) {
            throw new MetadataStoreException("Failed to create " + path, (Throwable)e);
        }
    }

    protected CompletableFuture<Void> createAsync(String path, T data) {
        return this.cache.create(path, data);
    }

    protected void delete(String path) throws MetadataStoreException {
        try {
            this.deleteAsync(path).get(this.operationTimeoutSec, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            throw e.getCause() instanceof MetadataStoreException ? (MetadataStoreException)e.getCause() : new MetadataStoreException(e.getCause());
        }
        catch (Exception e) {
            throw new MetadataStoreException("Failed to delete " + path, (Throwable)e);
        }
    }

    protected CompletableFuture<Void> deleteAsync(String path) {
        return this.cache.delete(path);
    }

    protected boolean exists(String path) throws MetadataStoreException {
        try {
            return (Boolean)this.cache.exists(path).get(this.operationTimeoutSec, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            throw e.getCause() instanceof MetadataStoreException ? (MetadataStoreException)e.getCause() : new MetadataStoreException(e.getCause());
        }
        catch (Exception e) {
            throw new MetadataStoreException("Failed to check exist " + path, (Throwable)e);
        }
    }

    protected CompletableFuture<Boolean> existsAsync(String path) {
        return this.cache.exists(path);
    }

    public int getOperationTimeoutSec() {
        return this.operationTimeoutSec;
    }

    protected static String joinPath(String ... parts) {
        StringBuilder sb = new StringBuilder();
        Joiner.on((char)'/').appendTo(sb, (Object[])parts);
        return sb.toString();
    }

    protected static CompletableFuture<Void> deleteRecursiveAsync(BaseResources resources, String pathRoot) {
        PathUtils.validatePath((String)pathRoot);
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        BaseResources.listSubTreeBFSAsync(resources, pathRoot).whenComplete((tree, ex) -> {
            if (ex == null) {
                log.debug("Deleting {} with size {}", tree, (Object)tree.size());
                ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
                for (int i = tree.size() - 1; i >= 0; --i) {
                    futures.add(resources.deleteAsync((String)tree.get(i)));
                }
                FutureUtil.waitForAll(futures).handle((result, exception) -> {
                    if (exception != null) {
                        log.error("Failed to remove partitioned topics", exception);
                        return completableFuture.completeExceptionally(exception.getCause());
                    }
                    return completableFuture.complete(null);
                });
            } else {
                log.warn("Failed to delete partitioned topics z-node [{}]", (Object)pathRoot, (Object)ex.getCause());
            }
        });
        return completableFuture;
    }

    protected static CompletableFuture<List<String>> listSubTreeBFSAsync(BaseResources resources, String pathRoot) {
        String node;
        LinkedList<String> queue = new LinkedList<String>();
        ArrayList<String> tree = new ArrayList<String>();
        queue.add(pathRoot);
        tree.add(pathRoot);
        CompletableFuture<List<String>> completableFuture = new CompletableFuture<List<String>>();
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
        for (int i = 0; i < queue.size() && (node = (String)queue.pollFirst()) != null; ++i) {
            futures.add(resources.getChildrenAsync(node).whenComplete((children, ex) -> {
                if (ex == null) {
                    for (String child : (List)children) {
                        String childPath = node + "/" + child;
                        queue.add(childPath);
                        tree.add(childPath);
                    }
                } else {
                    log.warn("Failed to get data error from z-node [{}]", (Object)node);
                }
            }));
        }
        FutureUtil.waitForAll(futures).handle((result, exception) -> {
            if (exception != null) {
                log.error("Failed to get partitioned topics", exception);
                return completableFuture.completeExceptionally(exception.getCause());
            }
            return completableFuture.complete(tree);
        });
        return completableFuture;
    }

    public MetadataStore getStore() {
        return this.store;
    }

    public MetadataCache<T> getCache() {
        return this.cache;
    }
}

