/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetty.tls;

import java.util.Set;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import org.apache.pulsar.common.util.DefaultSslContextBuilder;
import org.apache.pulsar.common.util.SecurityUtility;
import org.apache.pulsar.common.util.SslContextAutoRefreshBuilder;
import org.apache.pulsar.common.util.keystoretls.NetSslContextBuilder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettySslContextFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JettySslContextFactory.class);

    public static SslContextFactory.Server createServerSslContextWithKeystore(String sslProviderString, String keyStoreTypeString, String keyStore, String keyStorePassword, boolean allowInsecureConnection, String trustStoreTypeString, String trustStore, String trustStorePassword, boolean requireTrustedClientCertOnConnect, Set<String> ciphers, Set<String> protocols, long certRefreshInSec) {
        NetSslContextBuilder sslCtxRefresher = new NetSslContextBuilder(sslProviderString, keyStoreTypeString, keyStore, keyStorePassword, allowInsecureConnection, trustStoreTypeString, trustStore, trustStorePassword, requireTrustedClientCertOnConnect, certRefreshInSec);
        return new Server(sslProviderString, (SslContextAutoRefreshBuilder<SSLContext>)sslCtxRefresher, requireTrustedClientCertOnConnect, ciphers, protocols);
    }

    public static SslContextFactory createServerSslContext(String sslProviderString, boolean tlsAllowInsecureConnection, String tlsTrustCertsFilePath, String tlsCertificateFilePath, String tlsKeyFilePath, boolean tlsRequireTrustedClientCertOnConnect, Set<String> ciphers, Set<String> protocols, long certRefreshInSec) {
        DefaultSslContextBuilder sslCtxRefresher = new DefaultSslContextBuilder(tlsAllowInsecureConnection, tlsTrustCertsFilePath, tlsCertificateFilePath, tlsKeyFilePath, tlsRequireTrustedClientCertOnConnect, certRefreshInSec, sslProviderString);
        return new Server(sslProviderString, (SslContextAutoRefreshBuilder<SSLContext>)sslCtxRefresher, tlsRequireTrustedClientCertOnConnect, ciphers, protocols);
    }

    static {
        if (SecurityUtility.CONSCRYPT_PROVIDER != null) {
            // empty if block
        }
    }

    private static class Server
    extends SslContextFactory.Server {
        private final SslContextAutoRefreshBuilder<SSLContext> sslCtxRefresher;

        public Server(String sslProviderString, SslContextAutoRefreshBuilder<SSLContext> sslCtxRefresher, boolean requireTrustedClientCertOnConnect, Set<String> ciphers, Set<String> protocols) {
            this.sslCtxRefresher = sslCtxRefresher;
            if (ciphers != null && ciphers.size() > 0) {
                this.setIncludeCipherSuites(ciphers.toArray(new String[0]));
            }
            if (protocols != null && protocols.size() > 0) {
                this.setIncludeProtocols(protocols.toArray(new String[0]));
            }
            if (sslProviderString != null && !sslProviderString.equals("")) {
                this.setProvider(sslProviderString);
            }
            if (requireTrustedClientCertOnConnect) {
                this.setNeedClientAuth(true);
                this.setTrustAll(false);
            } else {
                this.setWantClientAuth(true);
                this.setTrustAll(true);
            }
        }

        public SSLContext getSslContext() {
            return (SSLContext)this.sslCtxRefresher.get();
        }
    }
}

