/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.persistent;

import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.common.events.EventsTopicNames;

public class SystemTopic
extends PersistentTopic {
    public SystemTopic(String topic, ManagedLedger ledger, BrokerService brokerService) throws PulsarServerException {
        super(topic, ledger, brokerService);
    }

    @Override
    public boolean isDeleteWhileInactive() {
        return false;
    }

    @Override
    public boolean isSizeBacklogExceeded() {
        return false;
    }

    @Override
    public CompletableFuture<Boolean> checkTimeBacklogExceeded() {
        return CompletableFuture.completedFuture(false);
    }

    @Override
    public boolean isSystemTopic() {
        return true;
    }

    @Override
    public void checkMessageExpiry() {
    }

    @Override
    public void checkGC() {
    }

    @Override
    public CompletableFuture<Void> checkReplication() {
        if (EventsTopicNames.isTopicPoliciesSystemTopic((String)this.topic)) {
            return super.checkReplication();
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Boolean> isCompactionEnabled() {
        return CompletableFuture.completedFuture(true);
    }
}

