/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.buffer.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.netty.buffer.ByteBuf;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCountUtil;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.transaction.TransactionBufferClientException;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.client.impl.ClientCnx;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.transaction.TransactionBufferHandler;
import org.apache.pulsar.common.api.proto.CommandEndTxnOnPartitionResponse;
import org.apache.pulsar.common.api.proto.CommandEndTxnOnSubscriptionResponse;
import org.apache.pulsar.common.api.proto.ServerError;
import org.apache.pulsar.common.api.proto.TxnAction;
import org.apache.pulsar.common.protocol.Commands;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionBufferHandlerImpl
implements TransactionBufferHandler {
    private static final Logger log = LoggerFactory.getLogger(TransactionBufferHandlerImpl.class);
    private final ConcurrentSkipListMap<Long, OpRequestSend> pendingRequests;
    private final AtomicLong requestIdGenerator = new AtomicLong();
    private final long operationTimeoutInMills;
    private final HashedWheelTimer timer;
    private final PulsarClient pulsarClient;
    private final LoadingCache<String, CompletableFuture<ClientCnx>> cache = CacheBuilder.newBuilder().maximumSize(100000L).expireAfterAccess(30L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, CompletableFuture<ClientCnx>>(){

        public CompletableFuture<ClientCnx> load(String topic) {
            CompletableFuture siFuture = TransactionBufferHandlerImpl.this.getClientCnx(topic);
            siFuture.whenComplete((si, cause) -> {
                if (null != cause) {
                    TransactionBufferHandlerImpl.this.cache.invalidate((Object)topic);
                }
            });
            return siFuture;
        }
    });

    public TransactionBufferHandlerImpl(PulsarClient pulsarClient, HashedWheelTimer timer) {
        this.pulsarClient = pulsarClient;
        this.pendingRequests = new ConcurrentSkipListMap();
        this.operationTimeoutInMills = 3000L;
        this.timer = timer;
    }

    public CompletableFuture<TxnID> endTxnOnTopic(String topic, long txnIdMostBits, long txnIdLeastBits, TxnAction action, long lowWaterMark) {
        if (log.isDebugEnabled()) {
            log.debug("[{}] endTxnOnTopic txnId: [{}], txnAction: [{}]", new Object[]{topic, new TxnID(txnIdMostBits, txnIdLeastBits), action.getValue()});
        }
        CompletableFuture<TxnID> cb = new CompletableFuture<TxnID>();
        long requestId = this.requestIdGenerator.getAndIncrement();
        ByteBuf cmd = Commands.newEndTxnOnPartition((long)requestId, (long)txnIdLeastBits, (long)txnIdMostBits, (String)topic, (TxnAction)action, (long)lowWaterMark);
        return this.endTxn(requestId, topic, cmd, cb);
    }

    public CompletableFuture<TxnID> endTxnOnSubscription(String topic, String subscription, long txnIdMostBits, long txnIdLeastBits, TxnAction action, long lowWaterMark) {
        if (log.isDebugEnabled()) {
            log.debug("[{}] endTxnOnSubscription txnId: [{}], txnAction: [{}]", new Object[]{topic, new TxnID(txnIdMostBits, txnIdLeastBits), action.getValue()});
        }
        CompletableFuture<TxnID> cb = new CompletableFuture<TxnID>();
        long requestId = this.requestIdGenerator.getAndIncrement();
        ByteBuf cmd = Commands.newEndTxnOnSubscription((long)requestId, (long)txnIdLeastBits, (long)txnIdMostBits, (String)topic, (String)subscription, (TxnAction)action, (long)lowWaterMark);
        return this.endTxn(requestId, topic, cmd, cb);
    }

    private CompletableFuture<TxnID> endTxn(long requestId, String topic, ByteBuf cmd, CompletableFuture<TxnID> cb) {
        OpRequestSend op = OpRequestSend.create(requestId, topic, cmd, cb);
        try {
            ((CompletableFuture)this.cache.get((Object)topic)).whenComplete((clientCnx, throwable) -> {
                if (throwable == null) {
                    if (clientCnx.ctx().channel().isActive()) {
                        clientCnx.registerTransactionBufferHandler((TransactionBufferHandler)this);
                        this.pendingRequests.put(requestId, op);
                        this.timer.newTimeout(timeout -> {
                            OpRequestSend peek = this.pendingRequests.remove(requestId);
                            if (peek != null && !peek.cb.isDone() && !peek.cb.isCompletedExceptionally()) {
                                peek.cb.completeExceptionally((Throwable)new TransactionBufferClientException.RequestTimeoutException());
                                this.onResponse(peek);
                            }
                        }, this.operationTimeoutInMills, TimeUnit.MILLISECONDS);
                        cmd.retain();
                        clientCnx.ctx().writeAndFlush((Object)cmd, clientCnx.ctx().voidPromise());
                    } else {
                        this.cache.invalidate((Object)topic);
                        cb.completeExceptionally((Throwable)new PulsarClientException.LookupException(topic + " endTxn channel is not active"));
                        op.recycle();
                    }
                } else {
                    log.error("endTxn error topic: [{}]", (Object)topic, throwable);
                    this.cache.invalidate((Object)topic);
                    cb.completeExceptionally((Throwable)new PulsarClientException.LookupException(throwable.getMessage()));
                    op.recycle();
                }
            });
        }
        catch (ExecutionException e) {
            log.error("endTxn channel is not active exception", (Throwable)e);
            this.cache.invalidate((Object)topic);
            cb.completeExceptionally((Throwable)new PulsarClientException.LookupException(e.getCause().getMessage()));
            op.recycle();
        }
        return cb;
    }

    public void handleEndTxnOnTopicResponse(long requestId, CommandEndTxnOnPartitionResponse response) {
        OpRequestSend op = this.pendingRequests.remove(requestId);
        if (op == null) {
            if (log.isDebugEnabled()) {
                log.debug("Got end txn on topic response for timeout {} - {}", (Object)response.getTxnidMostBits(), (Object)response.getTxnidLeastBits());
            }
            return;
        }
        if (!response.hasError()) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Got end txn on topic response for for request {}", (Object)op.topic, (Object)response.getRequestId());
            }
            op.cb.complete(new TxnID(response.getTxnidMostBits(), response.getTxnidLeastBits()));
        } else {
            log.error("[{}] Got end txn on topic response for request {} error {}", new Object[]{op.topic, response.getRequestId(), response.getError()});
            this.cache.invalidate((Object)op.topic);
            op.cb.completeExceptionally(ClientCnx.getPulsarClientException((ServerError)response.getError(), (String)response.getMessage()));
        }
        this.onResponse(op);
    }

    public void handleEndTxnOnSubscriptionResponse(long requestId, CommandEndTxnOnSubscriptionResponse response) {
        OpRequestSend op = this.pendingRequests.remove(requestId);
        if (op == null) {
            if (log.isDebugEnabled()) {
                log.debug("Got end txn on subscription response for timeout {} - {}", (Object)response.getTxnidMostBits(), (Object)response.getTxnidLeastBits());
            }
            return;
        }
        if (!response.hasError()) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Got end txn on subscription response for for request {}", (Object)op.topic, (Object)response.getRequestId());
            }
            op.cb.complete(new TxnID(response.getTxnidMostBits(), response.getTxnidLeastBits()));
        } else {
            log.error("[{}] Got end txn on subscription response for request {} error {}", new Object[]{op.topic, response.getRequestId(), response.getError()});
            this.cache.invalidate((Object)op.topic);
            op.cb.completeExceptionally(ClientCnx.getPulsarClientException((ServerError)response.getError(), (String)response.getMessage()));
        }
        this.onResponse(op);
    }

    void onResponse(OpRequestSend op) {
        ReferenceCountUtil.safeRelease((Object)op.byteBuf);
        op.recycle();
    }

    private CompletableFuture<ClientCnx> getClientCnx(String topic) {
        return ((PulsarClientImpl)this.pulsarClient).getConnection(topic);
    }

    public void close() {
        this.timer.stop();
    }

    private static final class OpRequestSend {
        long requestId;
        String topic;
        ByteBuf byteBuf;
        CompletableFuture<TxnID> cb;
        long createdAt;
        private final Recycler.Handle<OpRequestSend> recyclerHandle;
        private static final Recycler<OpRequestSend> RECYCLER = new Recycler<OpRequestSend>(){

            protected OpRequestSend newObject(Recycler.Handle<OpRequestSend> handle) {
                return new OpRequestSend(handle);
            }
        };

        static OpRequestSend create(long requestId, String topic, ByteBuf byteBuf, CompletableFuture<TxnID> cb) {
            OpRequestSend op = (OpRequestSend)RECYCLER.get();
            op.requestId = requestId;
            op.topic = topic;
            op.byteBuf = byteBuf;
            op.cb = cb;
            op.createdAt = System.currentTimeMillis();
            return op;
        }

        void recycle() {
            this.recyclerHandle.recycle((Object)this);
        }

        private OpRequestSend(Recycler.Handle<OpRequestSend> recyclerHandle) {
            this.recyclerHandle = recyclerHandle;
        }
    }
}

