/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.apache.pulsar.common.intercept.InterceptException;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.server.Response;

public class ExceptionHandler {
    public void handle(ServletResponse response, Exception ex) throws IOException {
        if (ex instanceof InterceptException) {
            String reason = ex.getMessage();
            byte[] content = reason.getBytes(StandardCharsets.UTF_8);
            MetaData.Response info = new MetaData.Response();
            info.setHttpVersion(HttpVersion.HTTP_1_1);
            info.setReason(reason);
            info.setStatus(((InterceptException)ex).getErrorCode());
            info.setContentLength((long)content.length);
            if (response instanceof Response) {
                ((Response)response).getHttpChannel().sendResponse(info, ByteBuffer.wrap(content), true);
            } else {
                ((HttpServletResponse)response).sendError(((InterceptException)ex).getErrorCode(), ex.getMessage());
            }
        } else {
            ((HttpServletResponse)response).sendError(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ex.getMessage());
        }
    }
}

