/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.impl;

import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authorization.AuthorizationService;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.policies.data.NamespaceOperation;
import org.apache.pulsar.packages.management.core.PackagesManagement;
import org.apache.pulsar.packages.management.core.common.PackageMetadata;
import org.apache.pulsar.packages.management.core.common.PackageName;
import org.apache.pulsar.packages.management.core.common.PackageType;
import org.apache.pulsar.packages.management.core.exceptions.PackagesManagementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackagesBase
extends AdminResource {
    private static final Logger log = LoggerFactory.getLogger(PackagesBase.class);
    private AuthorizationService authorizationService;

    private PackagesManagement getPackagesManagement() {
        return this.pulsar().getPackagesManagement();
    }

    private CompletableFuture<PackageName> getPackageNameAsync(String type, String tenant, String namespace, String packageName, String version) {
        CompletableFuture<PackageName> future = new CompletableFuture<PackageName>();
        try {
            PackageName name = PackageName.get((String)type, (String)tenant, (String)namespace, (String)packageName, (String)version);
            future.complete(name);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            future.completeExceptionally(illegalArgumentException);
        }
        return future;
    }

    private Void handleError(Throwable throwable, AsyncResponse asyncResponse) {
        if (throwable instanceof IllegalArgumentException) {
            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, throwable.getMessage())));
        } else if (throwable instanceof PackagesManagementException.NotFoundException) {
            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, throwable.getMessage())));
        } else if (throwable instanceof WebApplicationException) {
            asyncResponse.resume(throwable);
        } else {
            log.error("Encountered unexpected error", throwable);
            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.INTERNAL_SERVER_ERROR, throwable.getMessage())));
        }
        return null;
    }

    protected void internalGetMetadata(String type, String tenant, String namespace, String packageName, String version, AsyncResponse asyncResponse) {
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.checkPermissions(tenant, namespace).thenCompose(ignore -> this.getPackageNameAsync(type, tenant, namespace, packageName, version))).thenCompose(name -> this.getPackagesManagement().getMeta(name))).thenAccept(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0))).exceptionally(e -> this.handleError(e.getCause(), asyncResponse));
    }

    protected void internalUpdateMetadata(String type, String tenant, String namespace, String packageName, String version, PackageMetadata metadata, AsyncResponse asyncResponse) {
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.checkPermissions(tenant, namespace).thenCompose(ignore -> this.getPackageNameAsync(type, tenant, namespace, packageName, version))).thenCompose(name -> this.getPackagesManagement().updateMeta(name, metadata))).thenAccept(ignore -> asyncResponse.resume((Object)Response.noContent().build()))).exceptionally(e -> this.handleError(e.getCause(), asyncResponse));
    }

    protected StreamingOutput internalDownload(String type, String tenant, String namespace, String packageName, String version) {
        try {
            this.checkPermissions(tenant, namespace).get();
        }
        catch (InterruptedException e) {
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof WebApplicationException) {
                throw (WebApplicationException)e.getCause();
            }
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getCause().getMessage());
        }
        try {
            PackageName name = PackageName.get((String)type, (String)tenant, (String)namespace, (String)packageName, (String)version);
            return output -> {
                try {
                    this.getPackagesManagement().download(name, output).get();
                }
                catch (InterruptedException e) {
                    throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof PackagesManagementException.NotFoundException) {
                        throw new RestException(Response.Status.NOT_FOUND, e.getCause().getMessage());
                    }
                    throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getCause().getMessage());
                }
            };
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, illegalArgumentException.getMessage());
        }
    }

    protected void internalUpload(String type, String tenant, String namespace, String packageName, String version, PackageMetadata metadata, InputStream uploadedInputStream, AsyncResponse asyncResponse) {
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.checkPermissions(tenant, namespace).thenCompose(ignore -> this.getPackageNameAsync(type, tenant, namespace, packageName, version))).thenCompose(name -> this.getPackagesManagement().upload(name, metadata, uploadedInputStream))).thenAccept(ignore -> asyncResponse.resume((Object)Response.noContent().build()))).exceptionally(e -> this.handleError(e.getCause(), asyncResponse));
    }

    protected void internalDelete(String type, String tenant, String namespace, String packageName, String version, AsyncResponse asyncResponse) {
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.checkPermissions(tenant, namespace).thenCompose(ignore -> this.getPackageNameAsync(type, tenant, namespace, packageName, version))).thenCompose(name -> this.getPackagesManagement().delete(name))).thenAccept(ignore -> asyncResponse.resume((Object)Response.noContent().build()))).exceptionally(e -> this.handleError(e.getCause(), asyncResponse));
    }

    protected void internalListVersions(String type, String tenant, String namespace, String packageName, AsyncResponse asyncResponse) {
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.checkPermissions(tenant, namespace).thenCompose(ignore -> this.getPackageNameAsync(type, tenant, namespace, packageName, ""))).thenCompose(name -> this.getPackagesManagement().list(name))).thenAccept(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0))).exceptionally(e -> this.handleError(e.getCause(), asyncResponse));
    }

    protected void internalListPackages(String type, String tenant, String namespace, AsyncResponse asyncResponse) {
        try {
            PackageType packageType = PackageType.getEnum((String)type);
            ((CompletableFuture)((CompletableFuture)this.checkPermissions(tenant, namespace).thenCompose(ignore -> this.getPackagesManagement().list(packageType, tenant, namespace))).thenAccept(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0))).exceptionally(e -> this.handleError(e.getCause(), asyncResponse));
        }
        catch (IllegalArgumentException iae) {
            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, iae.getMessage())));
        }
    }

    private CompletableFuture<Void> checkPermissions(String tenant, String namespace) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (this.config().isAuthenticationEnabled()) {
            NamespaceName namespaceName;
            try {
                namespaceName = NamespaceName.get((String)tenant, (String)namespace);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
                return future;
            }
            this.getAuthorizationService().allowNamespaceOperationAsync(namespaceName, NamespaceOperation.PACKAGES, this.originalPrincipal(), this.clientAppId(), (AuthenticationDataSource)this.clientAuthData()).whenComplete((hasPermission, throwable) -> {
                if (throwable != null) {
                    future.completeExceptionally((Throwable)throwable);
                    return;
                }
                if (hasPermission.booleanValue()) {
                    future.complete(null);
                } else {
                    future.completeExceptionally((Throwable)((Object)new RestException(Response.Status.UNAUTHORIZED, String.format("Role %s has not the 'package' permission to do the packages operations.", this.clientAppId()))));
                }
            });
        } else {
            future.complete(null);
        }
        return future;
    }

    private AuthorizationService getAuthorizationService() {
        if (this.authorizationService == null) {
            this.authorizationService = this.pulsar().getBrokerService().getAuthorizationService();
            return this.authorizationService;
        }
        return this.authorizationService;
    }
}

