/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.v2;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.common.functions.WorkerInfo;
import org.apache.pulsar.common.io.ConnectorDefinition;
import org.apache.pulsar.functions.worker.WorkerService;
import org.apache.pulsar.functions.worker.service.api.Workers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/worker")
public class Worker
extends AdminResource
implements Supplier<WorkerService> {
    private static final Logger log = LoggerFactory.getLogger(Worker.class);

    Workers<? extends WorkerService> workers() {
        return this.pulsar().getWorkerService().getWorkers();
    }

    @Override
    public WorkerService get() {
        return this.pulsar().getWorkerService();
    }

    @GET
    @ApiOperation(value="Fetches information about the Pulsar cluster running Pulsar Functions", response=WorkerInfo.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=503, message="Worker service is not running")})
    @Path(value="/cluster")
    @Produces(value={"application/json"})
    public List<WorkerInfo> getCluster() {
        return this.workers().getCluster(this.clientAppId());
    }

    @GET
    @ApiOperation(value="Fetches info about the leader node of the Pulsar cluster running Pulsar Functions", response=WorkerInfo.class)
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=503, message="Worker service is not running")})
    @Path(value="/cluster/leader")
    @Produces(value={"application/json"})
    public WorkerInfo getClusterLeader() {
        return this.workers().getClusterLeader(this.clientAppId());
    }

    @GET
    @ApiOperation(value="Fetches information about which Pulsar Functions are assigned to which Pulsar clusters", response=Map.class)
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=503, message="Worker service is not running")})
    @Path(value="/assignments")
    @Produces(value={"application/json"})
    public Map<String, Collection<String>> getAssignments() {
        return this.workers().getAssignments(this.clientAppId());
    }

    @GET
    @ApiOperation(value="Fetches a list of supported Pulsar IO connectors currently running in cluster mode", response=List.class)
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=408, message="Request timeout")})
    @Path(value="/connectors")
    @Produces(value={"application/json"})
    public List<ConnectorDefinition> getConnectorsList() throws IOException {
        return this.workers().getListOfConnectors(this.clientAppId());
    }

    @PUT
    @ApiOperation(value="Triggers a rebalance of functions to workers")
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=408, message="Request timeout")})
    @Path(value="/rebalance")
    public void rebalance() {
        this.workers().rebalance(this.uri.getRequestUri(), this.clientAppId());
    }

    @GET
    @ApiOperation(value="Checks if this node is the leader and is ready to service requests", response=Boolean.class)
    @ApiResponses(value={@ApiResponse(code=503, message="Worker service is not running")})
    @Path(value="/cluster/leader/ready")
    public Boolean isLeaderReady() {
        return this.workers().isLeaderReady(this.clientAppId());
    }
}

