/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.systopic;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.broker.systopic.SystemTopicClient;
import org.apache.pulsar.broker.systopic.SystemTopicClientBase;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Reader;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.events.PulsarEvent;
import org.apache.pulsar.common.naming.TopicName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicPoliciesSystemTopicClient
extends SystemTopicClientBase<PulsarEvent> {
    private static final Logger log = LoggerFactory.getLogger(TopicPoliciesSystemTopicClient.class);

    public TopicPoliciesSystemTopicClient(PulsarClient client, TopicName topicName) {
        super(client, topicName);
    }

    @Override
    protected CompletableFuture<SystemTopicClient.Writer<PulsarEvent>> newWriterAsyncInternal() {
        return this.client.newProducer(Schema.AVRO(PulsarEvent.class)).topic(this.topicName.toString()).createAsync().thenCompose(producer -> {
            if (log.isDebugEnabled()) {
                log.debug("[{}] A new writer is created", (Object)this.topicName);
            }
            return CompletableFuture.completedFuture(new TopicPolicyWriter((Producer)producer, this));
        });
    }

    @Override
    protected CompletableFuture<SystemTopicClient.Reader<PulsarEvent>> newReaderAsyncInternal() {
        return this.client.newReader(Schema.AVRO(PulsarEvent.class)).topic(this.topicName.toString()).startMessageId(MessageId.earliest).readCompacted(true).createAsync().thenCompose(reader -> {
            if (log.isDebugEnabled()) {
                log.debug("[{}] A new reader is created", (Object)this.topicName);
            }
            return CompletableFuture.completedFuture(new TopicPolicyReader((Reader)reader, this));
        });
    }

    private static class TopicPolicyReader
    implements SystemTopicClient.Reader<PulsarEvent> {
        private final Reader<PulsarEvent> reader;
        private final TopicPoliciesSystemTopicClient systemTopic;

        private TopicPolicyReader(Reader<PulsarEvent> reader, TopicPoliciesSystemTopicClient systemTopic) {
            this.reader = reader;
            this.systemTopic = systemTopic;
        }

        @Override
        public Message<PulsarEvent> readNext() throws PulsarClientException {
            return this.reader.readNext();
        }

        @Override
        public CompletableFuture<Message<PulsarEvent>> readNextAsync() {
            return this.reader.readNextAsync();
        }

        @Override
        public boolean hasMoreEvents() throws PulsarClientException {
            return this.reader.hasMessageAvailable();
        }

        @Override
        public CompletableFuture<Boolean> hasMoreEventsAsync() {
            return this.reader.hasMessageAvailableAsync();
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
            this.systemTopic.getReaders().remove(this);
        }

        @Override
        public CompletableFuture<Void> closeAsync() {
            return this.reader.closeAsync().thenCompose(v -> {
                this.systemTopic.getReaders().remove(this);
                return CompletableFuture.completedFuture(null);
            });
        }

        @Override
        public SystemTopicClient<PulsarEvent> getSystemTopic() {
            return this.systemTopic;
        }
    }

    private static class TopicPolicyWriter
    implements SystemTopicClient.Writer<PulsarEvent> {
        private final Producer<PulsarEvent> producer;
        private final SystemTopicClient<PulsarEvent> systemTopicClient;

        private TopicPolicyWriter(Producer<PulsarEvent> producer, SystemTopicClient<PulsarEvent> systemTopicClient) {
            this.producer = producer;
            this.systemTopicClient = systemTopicClient;
        }

        @Override
        public MessageId write(PulsarEvent event) throws PulsarClientException {
            return this.producer.newMessage().key(this.getEventKey(event)).value((Object)event).send();
        }

        @Override
        public CompletableFuture<MessageId> writeAsync(PulsarEvent event) {
            return this.producer.newMessage().key(this.getEventKey(event)).value((Object)event).sendAsync();
        }

        private String getEventKey(PulsarEvent event) {
            return TopicName.get((String)event.getTopicPoliciesEvent().getDomain(), (String)event.getTopicPoliciesEvent().getTenant(), (String)event.getTopicPoliciesEvent().getNamespace(), (String)event.getTopicPoliciesEvent().getTopic()).toString();
        }

        @Override
        public void close() throws IOException {
            this.producer.close();
            this.systemTopicClient.getWriters().remove(this);
        }

        @Override
        public CompletableFuture<Void> closeAsync() {
            return this.producer.closeAsync().thenCompose(v -> {
                this.systemTopicClient.getWriters().remove(this);
                return CompletableFuture.completedFuture(null);
            });
        }

        @Override
        public SystemTopicClient<PulsarEvent> getSystemTopicClient() {
            return this.systemTopicClient;
        }
    }
}

