/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminBuilder;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.metadata.impl.ZKMetadataStore;
import org.apache.zookeeper.MockZooKeeper;
import org.apache.zookeeper.MockZooKeeperSession;
import org.apache.zookeeper.ZooKeeper;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;

public abstract class MultiBrokerBaseTest
extends MockedPulsarServiceBaseTest {
    protected List<PulsarService> additionalBrokers;
    protected List<PulsarAdmin> additionalBrokerAdmins;
    protected List<PulsarClient> additionalBrokerClients;

    protected int numberOfAdditionalBrokers() {
        return 2;
    }

    @Override
    @BeforeClass(alwaysRun=true)
    public final void setup() throws Exception {
        super.internalSetup();
        this.additionalBrokersSetup();
        this.pulsarResourcesSetup();
    }

    protected void pulsarResourcesSetup() throws PulsarAdminException {
        this.admin.tenants().createTenant("public", (TenantInfo)this.createDefaultTenantInfo());
        this.admin.namespaces().createNamespace("public/default", this.getPulsar().getConfiguration().getDefaultNumberOfNamespaceBundles());
    }

    protected void additionalBrokersSetup() throws Exception {
        int numberOfAdditionalBrokers = this.numberOfAdditionalBrokers();
        this.additionalBrokers = new ArrayList<PulsarService>(numberOfAdditionalBrokers);
        this.additionalBrokerAdmins = new ArrayList<PulsarAdmin>(numberOfAdditionalBrokers);
        this.additionalBrokerClients = new ArrayList<PulsarClient>(numberOfAdditionalBrokers);
        for (int i = 0; i < numberOfAdditionalBrokers; ++i) {
            PulsarService pulsarService = this.createAdditionalBroker(i);
            this.additionalBrokers.add(i, pulsarService);
            PulsarAdminBuilder pulsarAdminBuilder = PulsarAdmin.builder().serviceHttpUrl(pulsarService.getWebServiceAddress() != null ? pulsarService.getWebServiceAddress() : pulsarService.getWebServiceAddressTls());
            this.customizeNewPulsarAdminBuilder(pulsarAdminBuilder);
            this.additionalBrokerAdmins.add(i, pulsarAdminBuilder.build());
            this.additionalBrokerClients.add(i, this.newPulsarClient(pulsarService.getBrokerServiceUrl(), 0));
        }
    }

    protected ServiceConfiguration createConfForAdditionalBroker(int additionalBrokerIndex) {
        return MultiBrokerBaseTest.getDefaultConf();
    }

    protected PulsarService createAdditionalBroker(int additionalBrokerIndex) throws Exception {
        return this.startBroker(this.createConfForAdditionalBroker(additionalBrokerIndex));
    }

    @Override
    protected MetadataStoreExtended createLocalMetadataStore() throws MetadataStoreException {
        return new ZKMetadataStore((ZooKeeper)MockZooKeeperSession.newInstance((MockZooKeeper)this.mockZooKeeper));
    }

    @Override
    protected MetadataStoreExtended createConfigurationMetadataStore() throws MetadataStoreException {
        return new ZKMetadataStore((ZooKeeper)MockZooKeeperSession.newInstance((MockZooKeeper)this.mockZooKeeperGlobal));
    }

    @Override
    @AfterClass(alwaysRun=true)
    public final void cleanup() throws Exception {
        this.additionalBrokersCleanup();
        super.internalCleanup();
    }

    protected void additionalBrokersCleanup() {
        if (this.additionalBrokerAdmins != null) {
            for (PulsarAdmin additionalBrokerAdmin : this.additionalBrokerAdmins) {
                additionalBrokerAdmin.close();
            }
            this.additionalBrokerAdmins = null;
        }
        if (this.additionalBrokerClients != null) {
            for (PulsarClient additionalBrokerClient : this.additionalBrokerClients) {
                try {
                    additionalBrokerClient.shutdown();
                }
                catch (PulsarClientException pulsarClientException) {}
            }
            this.additionalBrokerClients = null;
        }
        if (this.additionalBrokers != null) {
            for (PulsarService pulsarService : this.additionalBrokers) {
                try {
                    pulsarService.getConfiguration().setBrokerShutdownTimeoutMs(0L);
                    pulsarService.close();
                }
                catch (PulsarServerException pulsarServerException) {}
            }
            this.additionalBrokers = null;
        }
    }

    public final List<PulsarService> getAllBrokers() {
        ArrayList<PulsarService> brokers = new ArrayList<PulsarService>(this.numberOfAdditionalBrokers() + 1);
        brokers.add(this.getPulsar());
        brokers.addAll(this.additionalBrokers);
        return Collections.unmodifiableList(brokers);
    }

    public final List<PulsarAdmin> getAllAdmins() {
        ArrayList<PulsarAdmin> admins = new ArrayList<PulsarAdmin>(this.numberOfAdditionalBrokers() + 1);
        admins.add(this.admin);
        admins.addAll(this.additionalBrokerAdmins);
        return Collections.unmodifiableList(admins);
    }

    public final List<PulsarClient> getAllClients() {
        ArrayList<PulsarClient> clients = new ArrayList<PulsarClient>(this.numberOfAdditionalBrokers() + 1);
        clients.add(this.pulsarClient);
        clients.addAll(this.additionalBrokerClients);
        return Collections.unmodifiableList(clients);
    }
}

