/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin;

import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"flaky"})
public class TopicMessageTTLTest
extends MockedPulsarServiceBaseTest {
    private static final Logger log = LoggerFactory.getLogger(TopicMessageTTLTest.class);
    private final String testTenant = "my-tenant";
    private final String testNamespace = "my-namespace";
    private final String myNamespace = "my-tenant/my-namespace";
    private final String testTopic = "persistent://my-tenant/my-namespace/test-topic-message-ttl";

    @Override
    @BeforeMethod
    protected void setup() throws Exception {
        this.resetConfig();
        this.conf.setSystemTopicEnabled(true);
        this.conf.setTopicLevelPoliciesEnabled(true);
        this.conf.setTtlDurationDefaultInSeconds(3600);
        super.internalSetup();
        this.admin.clusters().createCluster("test", ClusterData.builder().serviceUrl(this.pulsar.getWebServiceAddress()).build());
        TenantInfoImpl tenantInfo = new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.tenants().createTenant(this.testTenant, (TenantInfo)tenantInfo);
        this.admin.namespaces().createNamespace("my-tenant/my-namespace", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.topics().createPartitionedTopic("persistent://my-tenant/my-namespace/test-topic-message-ttl", 2);
        Producer producer = this.pulsarClient.newProducer().topic("my-tenant/my-namespace/dummy-topic").create();
        producer.close();
        this.waitForZooKeeperWatchers();
    }

    @Override
    @AfterMethod(alwaysRun=true)
    public void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testSetThenRemoveMessageTTL() throws Exception {
        this.admin.topics().setMessageTTL("persistent://my-tenant/my-namespace/test-topic-message-ttl", 100);
        log.info("Message TTL set success on topic: {}", (Object)"persistent://my-tenant/my-namespace/test-topic-message-ttl");
        this.waitForZooKeeperWatchers();
        Integer messageTTL = this.admin.topics().getMessageTTL("persistent://my-tenant/my-namespace/test-topic-message-ttl");
        log.info("Message TTL {} get on topic: {}", (Object)"persistent://my-tenant/my-namespace/test-topic-message-ttl", (Object)messageTTL);
        Assert.assertEquals((int)messageTTL, (int)100);
        this.waitForZooKeeperWatchers();
        this.admin.topics().removeMessageTTL("persistent://my-tenant/my-namespace/test-topic-message-ttl");
        messageTTL = this.admin.topics().getMessageTTL("persistent://my-tenant/my-namespace/test-topic-message-ttl");
        log.info("Message TTL {} get on topic: {}", (Object)"persistent://my-tenant/my-namespace/test-topic-message-ttl", (Object)messageTTL);
        Assert.assertNull((Object)messageTTL);
    }

    @Test
    public void testSetInvalidMessageTTL() throws Exception {
        try {
            this.admin.topics().setMessageTTL("persistent://my-tenant/my-namespace/test-topic-message-ttl", -100);
            Assert.fail();
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)412);
        }
        try {
            this.admin.topics().setMessageTTL("persistent://my-tenant/my-namespace/test-topic-message-ttl", -2147483646);
            Assert.fail();
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)412);
        }
    }

    @Test
    public void testGetMessageTTL() throws Exception {
        Integer messageTTL = this.admin.topics().getMessageTTL("persistent://my-tenant/my-namespace/test-topic-message-ttl");
        log.info("Message TTL {} get on topic: {}", (Object)"persistent://my-tenant/my-namespace/test-topic-message-ttl", (Object)messageTTL);
        Assert.assertNull((Object)messageTTL);
        this.admin.topics().setMessageTTL("persistent://my-tenant/my-namespace/test-topic-message-ttl", 200);
        log.info("Message TTL set success on topic: {}", (Object)"persistent://my-tenant/my-namespace/test-topic-message-ttl");
        this.waitForZooKeeperWatchers();
        messageTTL = this.admin.topics().getMessageTTL("persistent://my-tenant/my-namespace/test-topic-message-ttl");
        log.info("Message TTL {} get on topic: {}", (Object)"persistent://my-tenant/my-namespace/test-topic-message-ttl", (Object)messageTTL);
        Assert.assertEquals((int)messageTTL, (int)200);
    }

    @Test
    public void testTopicPolicyDisabled() throws Exception {
        super.internalCleanup();
        this.conf.setSystemTopicEnabled(true);
        this.conf.setTopicLevelPoliciesEnabled(false);
        super.internalSetup();
        this.admin.clusters().createCluster("test", ClusterData.builder().serviceUrl(this.pulsar.getWebServiceAddress()).build());
        TenantInfoImpl tenantInfo = new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.tenants().createTenant(this.testTenant, (TenantInfo)tenantInfo);
        this.admin.namespaces().createNamespace("my-tenant/my-namespace", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.topics().createPartitionedTopic("persistent://my-tenant/my-namespace/test-topic-message-ttl", 2);
        try {
            this.admin.topics().getMessageTTL("persistent://my-tenant/my-namespace/test-topic-message-ttl");
            Assert.fail();
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)405);
        }
        try {
            this.admin.topics().setMessageTTL("persistent://my-tenant/my-namespace/test-topic-message-ttl", 200);
            Assert.fail();
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)405);
        }
    }

    @Test(timeOut=20000L)
    public void testDifferentLevelPolicyPriority() throws Exception {
        String topicName = "persistent://my-tenant/my-namespace/test-topic-message-ttl" + UUID.randomUUID();
        this.admin.topics().createNonPartitionedTopic(topicName);
        PersistentTopic persistentTopic = (PersistentTopic)((Optional)this.pulsar.getBrokerService().getTopicIfExists(topicName).get()).get();
        Method method = PersistentTopic.class.getDeclaredMethod("getMessageTTL", new Class[0]);
        method.setAccessible(true);
        Integer namespaceMessageTTL = this.admin.namespaces().getNamespaceMessageTTL("my-tenant/my-namespace");
        Assert.assertNull((Object)namespaceMessageTTL);
        Assert.assertEquals((Object)method.invoke((Object)persistentTopic, new Object[0]), (Object)3600);
        this.admin.namespaces().setNamespaceMessageTTL("my-tenant/my-namespace", 10);
        Awaitility.await().untilAsserted(() -> Assert.assertEquals((int)this.admin.namespaces().getNamespaceMessageTTL("my-tenant/my-namespace"), (int)10));
        Assert.assertEquals((int)((Integer)method.invoke((Object)persistentTopic, new Object[0])), (int)10);
        this.admin.namespaces().setNamespaceMessageTTL("my-tenant/my-namespace", 0);
        Awaitility.await().untilAsserted(() -> Assert.assertEquals((int)this.admin.namespaces().getNamespaceMessageTTL("my-tenant/my-namespace"), (int)0));
        Assert.assertEquals((int)((Integer)method.invoke((Object)persistentTopic, new Object[0])), (int)0);
        this.admin.namespaces().removeNamespaceMessageTTL("my-tenant/my-namespace");
        Awaitility.await().untilAsserted(() -> Assert.assertNull((Object)this.admin.namespaces().getNamespaceMessageTTL("my-tenant/my-namespace")));
        Assert.assertEquals((int)((Integer)method.invoke((Object)persistentTopic, new Object[0])), (int)3600);
    }

    @Test(timeOut=20000L)
    public void testDifferentLevelPolicyApplied() throws Exception {
        String topicName = "persistent://my-tenant/my-namespace/test-topic-message-ttl" + UUID.randomUUID();
        this.admin.topics().createNonPartitionedTopic(topicName);
        PersistentTopic persistentTopic = (PersistentTopic)((Optional)this.pulsar.getBrokerService().getTopicIfExists(topicName).get()).get();
        Method method = PersistentTopic.class.getDeclaredMethod("getMessageTTL", new Class[0]);
        method.setAccessible(true);
        Integer namespaceMessageTTL = this.admin.namespaces().getNamespaceMessageTTL("my-tenant/my-namespace");
        Assert.assertNull((Object)namespaceMessageTTL);
        Integer topicMessageTTL = this.admin.topics().getMessageTTL(topicName);
        Assert.assertNull((Object)topicMessageTTL);
        int topicMessageTTLApplied = this.admin.topics().getMessageTTL(topicName, true);
        Assert.assertEquals((int)topicMessageTTLApplied, (int)3600);
        this.admin.namespaces().setNamespaceMessageTTL("my-tenant/my-namespace", 10);
        Awaitility.await().untilAsserted(() -> Assert.assertEquals((int)this.admin.namespaces().getNamespaceMessageTTL("my-tenant/my-namespace"), (int)10));
        topicMessageTTLApplied = this.admin.topics().getMessageTTL(topicName, true);
        Assert.assertEquals((int)topicMessageTTLApplied, (int)10);
        this.admin.namespaces().setNamespaceMessageTTL("my-tenant/my-namespace", 0);
        Awaitility.await().untilAsserted(() -> Assert.assertEquals((int)this.admin.namespaces().getNamespaceMessageTTL("my-tenant/my-namespace"), (int)0));
        topicMessageTTLApplied = this.admin.topics().getMessageTTL(topicName, true);
        Assert.assertEquals((int)topicMessageTTLApplied, (int)0);
        this.admin.topics().setMessageTTL(topicName, 20);
        Awaitility.await().untilAsserted(() -> Assert.assertNotNull((Object)this.admin.topics().getMessageTTL(topicName)));
        topicMessageTTLApplied = this.admin.topics().getMessageTTL(topicName, true);
        Assert.assertEquals((int)topicMessageTTLApplied, (int)20);
        this.admin.namespaces().removeNamespaceMessageTTL("my-tenant/my-namespace");
        this.admin.topics().removeMessageTTL(topicName);
        Awaitility.await().untilAsserted(() -> Assert.assertEquals((int)this.admin.topics().getMessageTTL(topicName, true), (int)3600));
        Assert.assertEquals((int)((Integer)method.invoke((Object)persistentTopic, new Object[0])), (int)3600);
    }
}

