/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.auth;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.pulsar.broker.auth.MockAuthentication;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"flaky"})
public class AuthLogsTest
extends MockedPulsarServiceBaseTest {
    private static final Logger log = LoggerFactory.getLogger(AuthLogsTest.class);

    @Override
    @BeforeClass
    public void setup() throws Exception {
        this.conf.setClusterName("test");
        this.conf.setAuthenticationEnabled(true);
        this.conf.setAuthenticationProviders((Set)Sets.newHashSet((Object[])new String[]{"org.apache.pulsar.broker.auth.MockAuthenticationProvider"}));
        this.conf.setAuthorizationProvider("org.apache.pulsar.broker.auth.MockAuthorizationProvider");
        this.conf.setAuthorizationEnabled(true);
        this.conf.setAuthorizationAllowWildcardsMatching(true);
        this.conf.setSuperUserRoles((Set)Sets.newHashSet((Object[])new String[]{"super"}));
        this.internalSetup();
        try (PulsarAdmin admin = PulsarAdmin.builder().authentication((Authentication)new MockAuthentication("pass.pass")).serviceHttpUrl(this.brokerUrl.toString()).build();){
            admin.clusters().createCluster("test", ClusterData.builder().serviceUrl(this.pulsar.getWebServiceAddress()).build());
            admin.tenants().createTenant("public", (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"appid1", "appid2"}), (Set)Sets.newHashSet((Object[])new String[]{"test"})));
            admin.namespaces().createNamespace("public/default");
            admin.namespaces().setNamespaceReplicationClusters("public/default", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        }
    }

    @Override
    @AfterClass(alwaysRun=true)
    public void cleanup() throws Exception {
        this.internalCleanup();
    }

    @Test
    public void binaryEndpoint() throws Exception {
        Consumer consumer;
        Producer producer;
        log.info("LOG_TEST_SUCCESS_CLIENT should succeeed both client");
        try (PulsarClient client = PulsarClient.builder().serviceUrl(this.pulsar.getBrokerServiceUrl()).authentication((Authentication)new MockAuthentication("pass.pass")).build();){
            producer = client.newProducer().topic("foobar").create();
            try {
                Consumer consumer2 = client.newConsumer().topic(new String[]{"foobar"}).subscriptionName("foobar").subscribe();
                if (consumer2 != null) {
                    consumer2.close();
                }
            }
            finally {
                if (producer != null) {
                    producer.close();
                }
            }
        }
        log.info("LOG_TEST_PRODUCER_AUTHN_FAIL");
        try {
            client = PulsarClient.builder().serviceUrl(this.pulsar.getBrokerServiceUrl()).authentication((Authentication)new MockAuthentication("fail.ignored")).build();
            try {
                producer = client.newProducer().topic("foobar").create();
                try {
                    Assert.fail((String)"Should fail auth");
                }
                finally {
                    if (producer != null) {
                        producer.close();
                    }
                }
            }
            finally {
                if (client != null) {
                    client.close();
                }
            }
        }
        catch (PulsarClientException.AuthenticationException client2) {
            // empty catch block
        }
        log.info("LOG_TEST_PRODUCER_AUTHN_ERROR");
        try {
            client = PulsarClient.builder().serviceUrl(this.pulsar.getBrokerServiceUrl()).authentication((Authentication)new MockAuthentication("error.ignored")).build();
            try {
                producer = client.newProducer().topic("foobar").create();
                try {
                    Assert.fail((String)"Should fail auth");
                }
                finally {
                    if (producer != null) {
                        producer.close();
                    }
                }
            }
            finally {
                if (client != null) {
                    client.close();
                }
            }
        }
        catch (PulsarClientException.AuthenticationException client3) {
            // empty catch block
        }
        log.info("LOG_TEST_CONSUMER_AUTHN_FAIL");
        try {
            client = PulsarClient.builder().serviceUrl(this.pulsar.getBrokerServiceUrl()).authentication((Authentication)new MockAuthentication("fail.ignored")).build();
            try {
                consumer = client.newConsumer().topic(new String[]{"foobar"}).subscriptionName("foobar").subscribe();
                try {
                    Assert.fail((String)"Should fail auth");
                }
                finally {
                    if (consumer != null) {
                        consumer.close();
                    }
                }
            }
            finally {
                if (client != null) {
                    client.close();
                }
            }
        }
        catch (PulsarClientException.AuthenticationException client4) {
            // empty catch block
        }
        log.info("LOG_TEST_CONSUMER_AUTHN_ERROR");
        try {
            client = PulsarClient.builder().serviceUrl(this.pulsar.getBrokerServiceUrl()).authentication((Authentication)new MockAuthentication("error.ignored")).build();
            try {
                consumer = client.newConsumer().topic(new String[]{"foobar"}).subscriptionName("foobar").subscribe();
                try {
                    Assert.fail((String)"Should fail auth");
                }
                finally {
                    if (consumer != null) {
                        consumer.close();
                    }
                }
            }
            finally {
                if (client != null) {
                    client.close();
                }
            }
        }
        catch (PulsarClientException.AuthenticationException client5) {
            // empty catch block
        }
        log.info("LOG_TEST_PRODUCER_AUTHZ_FAIL");
        try {
            client = PulsarClient.builder().serviceUrl(this.pulsar.getBrokerServiceUrl()).authentication((Authentication)new MockAuthentication("pass.fail")).build();
            try {
                producer = client.newProducer().topic("foobar").create();
                try {
                    Assert.fail((String)"Should fail auth");
                }
                finally {
                    if (producer != null) {
                        producer.close();
                    }
                }
            }
            finally {
                if (client != null) {
                    client.close();
                }
            }
        }
        catch (PulsarClientException.AuthorizationException client6) {
            // empty catch block
        }
        log.info("LOG_TEST_PRODUCER_AUTHZ_ERROR");
        try {
            client = PulsarClient.builder().serviceUrl(this.pulsar.getBrokerServiceUrl()).authentication((Authentication)new MockAuthentication("pass.error")).build();
            try {
                producer = client.newProducer().topic("foobar").create();
                try {
                    Assert.fail((String)"Should fail auth");
                }
                finally {
                    if (producer != null) {
                        producer.close();
                    }
                }
            }
            finally {
                if (client != null) {
                    client.close();
                }
            }
        }
        catch (PulsarClientException.AuthorizationException client7) {
            // empty catch block
        }
        log.info("LOG_TEST_CONSUMER_AUTHZ_FAIL");
        try {
            client = PulsarClient.builder().serviceUrl(this.pulsar.getBrokerServiceUrl()).authentication((Authentication)new MockAuthentication("pass.fail")).build();
            try {
                consumer = client.newConsumer().topic(new String[]{"foobar"}).subscriptionName("foobar").subscribe();
                try {
                    Assert.fail((String)"Should fail auth");
                }
                finally {
                    if (consumer != null) {
                        consumer.close();
                    }
                }
            }
            finally {
                if (client != null) {
                    client.close();
                }
            }
        }
        catch (PulsarClientException.AuthorizationException client8) {
            // empty catch block
        }
        log.info("LOG_TEST_CONSUMER_AUTHZ_ERROR");
        try {
            client = PulsarClient.builder().serviceUrl(this.pulsar.getBrokerServiceUrl()).authentication((Authentication)new MockAuthentication("pass.error")).build();
            try {
                consumer = client.newConsumer().topic(new String[]{"foobar"}).subscriptionName("foobar").subscribe();
                try {
                    Assert.fail((String)"Should fail auth");
                }
                finally {
                    if (consumer != null) {
                        consumer.close();
                    }
                }
            }
            finally {
                if (client != null) {
                    client.close();
                }
            }
        }
        catch (PulsarClientException.AuthorizationException authorizationException) {
            // empty catch block
        }
        log.info("LOG_TEST_CLIENT_DONE");
    }

    @Test
    public void httpEndpoint() throws Exception {
        log.info("LOG_TEST_SUCCESS_CLIENT should succeeed both client");
        try (PulsarAdmin admin = PulsarAdmin.builder().authentication((Authentication)new MockAuthentication("pass.pass")).serviceHttpUrl(this.brokerUrl.toString()).build();){
            admin.namespaces().getNamespaces("public");
        }
        log.info("LOG_TEST_HTTP_AUTHN_FAIL");
        try {
            admin = PulsarAdmin.builder().authentication((Authentication)new MockAuthentication("fail.ignore")).serviceHttpUrl(this.brokerUrl.toString()).build();
            try {
                admin.namespaces().getNamespaces("public");
                Assert.fail((String)"Should fail auth");
            }
            finally {
                if (admin != null) {
                    admin.close();
                }
            }
        }
        catch (PulsarAdminException.NotAuthorizedException admin2) {
            // empty catch block
        }
        log.info("LOG_TEST_HTTP_AUTHN_ERROR");
        try {
            admin = PulsarAdmin.builder().authentication((Authentication)new MockAuthentication("error.ignore")).serviceHttpUrl(this.brokerUrl.toString()).build();
            try {
                admin.namespaces().getNamespaces("public");
                Assert.fail((String)"Should fail auth");
            }
            finally {
                if (admin != null) {
                    admin.close();
                }
            }
        }
        catch (PulsarAdminException.NotAuthorizedException admin3) {
            // empty catch block
        }
        log.info("LOG_TEST_HTTP_AUTHZ_FAIL");
        try {
            admin = PulsarAdmin.builder().authentication((Authentication)new MockAuthentication("pass.fail")).serviceHttpUrl(this.brokerUrl.toString()).build();
            try {
                admin.namespaces().getNamespaces("public");
                Assert.fail((String)"Should fail auth");
            }
            finally {
                if (admin != null) {
                    admin.close();
                }
            }
        }
        catch (PulsarAdminException.NotAuthorizedException admin4) {
            // empty catch block
        }
        log.info("LOG_TEST_HTTP_AUTHZ_ERROR");
        try {
            admin = PulsarAdmin.builder().authentication((Authentication)new MockAuthentication("pass.error")).serviceHttpUrl(this.brokerUrl.toString()).build();
            try {
                admin.namespaces().getNamespaces("public");
                Assert.fail((String)"Should fail auth");
            }
            finally {
                if (admin != null) {
                    admin.close();
                }
            }
        }
        catch (PulsarAdminException.ServerSideErrorException serverSideErrorException) {
            // empty catch block
        }
        log.info("LOG_TEST_CLIENT_DONE");
    }
}

