/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.cache;

import com.google.common.hash.Hashing;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.cache.LocalZooKeeperCacheService;
import org.apache.pulsar.broker.cache.ResourceQuotaCache;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.NamespaceBundleFactory;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.policies.data.ResourceQuota;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.zookeeper.LocalZooKeeperCache;
import org.apache.pulsar.zookeeper.ZooKeeperCache;
import org.apache.zookeeper.MockZooKeeper;
import org.apache.zookeeper.ZooKeeper;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class ResourceQuotaCacheTest {
    private PulsarService pulsar;
    private ZooKeeperCache zkCache;
    private LocalZooKeeperCacheService localCache;
    private NamespaceBundleFactory bundleFactory;
    private OrderedScheduler executor;
    private MockZooKeeper zkc;

    @BeforeMethod
    public void setup() throws Exception {
        this.pulsar = (PulsarService)Mockito.mock(PulsarService.class);
        this.executor = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().numThreads(1).name("test").build();
        this.zkc = MockZooKeeper.newInstance();
        this.zkCache = new LocalZooKeeperCache((ZooKeeper)this.zkc, 30, (OrderedExecutor)this.executor);
        this.localCache = new LocalZooKeeperCacheService(this.zkCache, null);
        Mockito.when((Object)this.pulsar.getLocalMetadataStore()).thenReturn((Object)((MetadataStoreExtended)Mockito.mock(MetadataStoreExtended.class)));
        Mockito.when((Object)this.pulsar.getConfigurationMetadataStore()).thenReturn((Object)((MetadataStoreExtended)Mockito.mock(MetadataStoreExtended.class)));
        this.bundleFactory = new NamespaceBundleFactory(this.pulsar, Hashing.crc32());
        ((PulsarService)Mockito.doReturn((Object)this.zkCache).when((Object)this.pulsar)).getLocalZkCache();
        ((PulsarService)Mockito.doReturn((Object)this.localCache).when((Object)this.pulsar)).getLocalZkCacheService();
    }

    @AfterMethod(alwaysRun=true)
    public void teardown() throws Exception {
        this.executor.shutdownNow();
        this.zkCache.stop();
        this.zkc.shutdown();
    }

    @Test
    public void testGetSetDefaultQuota() throws Exception {
        ResourceQuotaCache cache = new ResourceQuotaCache(this.zkCache);
        ResourceQuota quota1 = ResourceQuotaCache.getInitialQuotaValue();
        ResourceQuota quota2 = new ResourceQuota();
        quota2.setMsgRateIn(10.0);
        quota2.setMsgRateOut(20.0);
        quota2.setBandwidthIn(10000.0);
        quota2.setBandwidthOut(20000.0);
        quota2.setMemory(100.0);
        quota2.setDynamic(false);
        Assert.assertEquals((Object)cache.getDefaultQuota(), (Object)quota1);
        cache.setDefaultQuota(quota2);
        Assert.assertEquals((Object)cache.getDefaultQuota(), (Object)quota2);
    }

    @Test
    public void testGetSetBundleQuota() throws Exception {
        ResourceQuotaCache cache = new ResourceQuotaCache(this.zkCache);
        NamespaceBundle testBundle = this.bundleFactory.getFullBundle(NamespaceName.get((String)"pulsar/test/ns-2"));
        ResourceQuota quota1 = ResourceQuotaCache.getInitialQuotaValue();
        ResourceQuota quota2 = new ResourceQuota();
        quota2.setMsgRateIn(10.0);
        quota2.setMsgRateOut(20.0);
        quota2.setBandwidthIn(10000.0);
        quota2.setBandwidthOut(20000.0);
        quota2.setMemory(100.0);
        quota2.setDynamic(false);
        Assert.assertEquals((Object)cache.getQuota(testBundle), (Object)quota1);
        cache.setQuota(testBundle, quota2);
        Assert.assertEquals((Object)cache.getQuota(testBundle), (Object)quota2);
        cache.unsetQuota(testBundle);
        Assert.assertEquals((Object)cache.getQuota(testBundle), (Object)quota1);
    }
}

