/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance;

import com.beust.jcommander.internal.Maps;
import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.loadbalance.impl.LoadManagerShared;
import org.apache.pulsar.broker.loadbalance.impl.ModularLoadManagerImpl;
import org.apache.pulsar.broker.loadbalance.impl.ModularLoadManagerWrapper;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.NamespaceBundleFactory;
import org.apache.pulsar.common.naming.NamespaceBundles;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.ServiceUnitId;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.FailureDomain;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.common.util.collections.ConcurrentOpenHashMap;
import org.apache.pulsar.common.util.collections.ConcurrentOpenHashSet;
import org.apache.pulsar.zookeeper.LocalBookkeeperEnsemble;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class AntiAffinityNamespaceGroupTest {
    private LocalBookkeeperEnsemble bkEnsemble;
    private URL url1;
    private PulsarService pulsar1;
    private PulsarAdmin admin1;
    private URL url2;
    private PulsarService pulsar2;
    private PulsarAdmin admin2;
    private String primaryHost;
    private String secondaryHost;
    private NamespaceBundleFactory nsFactory;
    private ModularLoadManagerImpl primaryLoadManager;
    private ModularLoadManagerImpl secondaryLoadManager;
    private ExecutorService executor;

    private static Object getField(Object instance, String fieldName) throws Exception {
        Field field = instance.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        return field.get(instance);
    }

    @BeforeMethod
    void setup() throws Exception {
        this.executor = new ThreadPoolExecutor(5, 20, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        this.bkEnsemble = new LocalBookkeeperEnsemble(3, 0, () -> 0);
        this.bkEnsemble.start();
        ServiceConfiguration config1 = new ServiceConfiguration();
        config1.setLoadManagerClassName(ModularLoadManagerImpl.class.getName());
        config1.setClusterName("use");
        config1.setWebServicePort(Optional.of(0));
        config1.setZookeeperServers("127.0.0.1:" + this.bkEnsemble.getZookeeperPort());
        config1.setBrokerShutdownTimeoutMs(0L);
        config1.setBrokerServicePort(Optional.of(0));
        config1.setFailureDomainsEnabled(true);
        config1.setLoadBalancerEnabled(true);
        config1.setAdvertisedAddress("localhost");
        config1.setLoadBalancerBrokerOverloadedThresholdPercentage(400);
        this.createCluster(this.bkEnsemble.getZkClient(), config1);
        this.pulsar1 = new PulsarService(config1);
        this.pulsar1.start();
        this.primaryHost = String.format("%s:%d", "localhost", this.pulsar1.getListenPortHTTP().get());
        this.url1 = new URL("http://127.0.0.1:" + this.pulsar1.getListenPortHTTP().get());
        this.admin1 = PulsarAdmin.builder().serviceHttpUrl(this.url1.toString()).build();
        ServiceConfiguration config2 = new ServiceConfiguration();
        config2.setLoadManagerClassName(ModularLoadManagerImpl.class.getName());
        config2.setClusterName("use");
        config2.setWebServicePort(Optional.of(0));
        config2.setZookeeperServers("127.0.0.1:" + this.bkEnsemble.getZookeeperPort());
        config2.setBrokerShutdownTimeoutMs(0L);
        config2.setBrokerServicePort(Optional.of(0));
        config2.setFailureDomainsEnabled(true);
        config2.setAdvertisedAddress("localhost");
        config2.setLoadBalancerBrokerOverloadedThresholdPercentage(400);
        this.pulsar2 = new PulsarService(config2);
        this.pulsar2.start();
        this.secondaryHost = String.format("%s:%d", "localhost", this.pulsar2.getListenPortHTTP().get());
        this.url2 = new URL("http://127.0.0.1:" + config2.getWebServicePort().get());
        this.admin2 = PulsarAdmin.builder().serviceHttpUrl(this.url2.toString()).build();
        this.primaryLoadManager = (ModularLoadManagerImpl)AntiAffinityNamespaceGroupTest.getField(this.pulsar1.getLoadManager().get(), "loadManager");
        this.secondaryLoadManager = (ModularLoadManagerImpl)AntiAffinityNamespaceGroupTest.getField(this.pulsar2.getLoadManager().get(), "loadManager");
        this.nsFactory = new NamespaceBundleFactory(this.pulsar1, Hashing.crc32());
        Thread.sleep(100L);
    }

    @AfterMethod(alwaysRun=true)
    void shutdown() throws Exception {
        this.executor.shutdownNow();
        this.admin1.close();
        this.admin2.close();
        this.pulsar2.close();
        this.pulsar1.close();
        this.bkEnsemble.stop();
    }

    private void createCluster(ZooKeeper zk, ServiceConfiguration config) throws Exception {
        ZkUtils.createFullPathOptimistic((ZooKeeper)zk, (String)("/admin/clusters/" + config.getClusterName()), (byte[])ObjectMapperFactory.getThreadLocal().writeValueAsBytes((Object)ClusterData.builder().serviceUrl("http://" + config.getAdvertisedAddress() + ":" + config.getWebServicePort().get()).build()), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT);
    }

    @Test
    public void testClusterDomain() {
    }

    @Test
    public void testAntiAffinityNamespaceFilteringWithDomain() throws Exception {
        String namespace = "my-tenant/use/my-ns";
        int totalNamespaces = 5;
        String namespaceAntiAffinityGroup = "my-antiaffinity";
        String bundle = "/0x00000000_0xffffffff";
        int totalBrokers = 4;
        this.pulsar1.getConfiguration().setFailureDomainsEnabled(true);
        this.admin1.tenants().createTenant("my-tenant", (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"appid1", "appid2"}), (Set)Sets.newHashSet((Object[])new String[]{"use"})));
        for (int i = 0; i < 5; ++i) {
            String ns = "my-tenant/use/my-ns" + i;
            this.admin1.namespaces().createNamespace(ns);
            this.admin1.namespaces().setNamespaceAntiAffinityGroup(ns, "my-antiaffinity");
        }
        HashSet brokers = Sets.newHashSet();
        Map brokerToDomainMap = Maps.newHashMap();
        brokers.add("brokerName-0");
        brokerToDomainMap.put("brokerName-0", "domain-0");
        brokers.add("brokerName-1");
        brokerToDomainMap.put("brokerName-1", "domain-0");
        brokers.add("brokerName-2");
        brokerToDomainMap.put("brokerName-2", "domain-1");
        brokers.add("brokerName-3");
        brokerToDomainMap.put("brokerName-3", "domain-1");
        HashSet candidate = Sets.newHashSet();
        ConcurrentOpenHashMap brokerToNamespaceToBundleRange = new ConcurrentOpenHashMap();
        Assert.assertEquals((int)brokers.size(), (int)4);
        String assignedNamespace = "my-tenant/use/my-ns0/0x00000000_0xffffffff";
        candidate.addAll(brokers);
        LoadManagerShared.filterAntiAffinityGroupOwnedBrokers((PulsarService)this.pulsar1, (String)assignedNamespace, (Set)brokers, (ConcurrentOpenHashMap)brokerToNamespaceToBundleRange, (Map)brokerToDomainMap);
        Assert.assertEquals((int)brokers.size(), (int)4);
        this.selectBrokerForNamespace((ConcurrentOpenHashMap<String, ConcurrentOpenHashMap<String, ConcurrentOpenHashSet<String>>>)brokerToNamespaceToBundleRange, "brokerName-0", "my-tenant/use/my-ns0", assignedNamespace);
        candidate.addAll(brokers);
        assignedNamespace = "my-tenant/use/my-ns1/0x00000000_0xffffffff";
        LoadManagerShared.filterAntiAffinityGroupOwnedBrokers((PulsarService)this.pulsar1, (String)assignedNamespace, (Set)candidate, (ConcurrentOpenHashMap)brokerToNamespaceToBundleRange, (Map)brokerToDomainMap);
        Assert.assertEquals((int)candidate.size(), (int)2);
        candidate.forEach(broker -> Assert.assertEquals((String)((String)brokerToDomainMap.get(broker)), (String)"domain-1"));
        this.selectBrokerForNamespace((ConcurrentOpenHashMap<String, ConcurrentOpenHashMap<String, ConcurrentOpenHashSet<String>>>)brokerToNamespaceToBundleRange, "brokerName-2", "my-tenant/use/my-ns1", assignedNamespace);
        candidate.addAll(brokers);
        assignedNamespace = "my-tenant/use/my-ns2/0x00000000_0xffffffff";
        LoadManagerShared.filterAntiAffinityGroupOwnedBrokers((PulsarService)this.pulsar1, (String)assignedNamespace, (Set)candidate, (ConcurrentOpenHashMap)brokerToNamespaceToBundleRange, (Map)brokerToDomainMap);
        Assert.assertEquals((int)candidate.size(), (int)2);
        Assert.assertTrue((boolean)candidate.contains("brokerName-1"));
        Assert.assertTrue((boolean)candidate.contains("brokerName-3"));
        this.selectBrokerForNamespace((ConcurrentOpenHashMap<String, ConcurrentOpenHashMap<String, ConcurrentOpenHashSet<String>>>)brokerToNamespaceToBundleRange, "brokerName-1", "my-tenant/use/my-ns2", assignedNamespace);
        candidate.addAll(brokers);
        assignedNamespace = "my-tenant/use/my-ns3/0x00000000_0xffffffff";
        LoadManagerShared.filterAntiAffinityGroupOwnedBrokers((PulsarService)this.pulsar1, (String)assignedNamespace, (Set)candidate, (ConcurrentOpenHashMap)brokerToNamespaceToBundleRange, (Map)brokerToDomainMap);
        Assert.assertEquals((int)candidate.size(), (int)1);
        Assert.assertTrue((boolean)candidate.contains("brokerName-3"));
        this.selectBrokerForNamespace((ConcurrentOpenHashMap<String, ConcurrentOpenHashMap<String, ConcurrentOpenHashSet<String>>>)brokerToNamespaceToBundleRange, "brokerName-3", "my-tenant/use/my-ns3", assignedNamespace);
        candidate.addAll(brokers);
        assignedNamespace = "my-tenant/use/my-ns4/0x00000000_0xffffffff";
        LoadManagerShared.filterAntiAffinityGroupOwnedBrokers((PulsarService)this.pulsar1, (String)assignedNamespace, (Set)candidate, (ConcurrentOpenHashMap)brokerToNamespaceToBundleRange, (Map)brokerToDomainMap);
        Assert.assertEquals((int)candidate.size(), (int)4);
    }

    @Test
    public void testAntiAffinityNamespaceFilteringWithoutDomain() throws Exception {
        String namespace = "my-tenant/use/my-ns";
        int totalNamespaces = 5;
        String namespaceAntiAffinityGroup = "my-antiaffinity";
        String bundle = "/0x00000000_0xffffffff";
        this.admin1.tenants().createTenant("my-tenant", (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"appid1", "appid2"}), (Set)Sets.newHashSet((Object[])new String[]{"use"})));
        for (int i = 0; i < 5; ++i) {
            String ns = "my-tenant/use/my-ns" + i;
            this.admin1.namespaces().createNamespace(ns);
            this.admin1.namespaces().setNamespaceAntiAffinityGroup(ns, "my-antiaffinity");
        }
        HashSet brokers = Sets.newHashSet();
        HashSet candidate = Sets.newHashSet();
        ConcurrentOpenHashMap brokerToNamespaceToBundleRange = new ConcurrentOpenHashMap();
        brokers.add("broker-0");
        brokers.add("broker-1");
        brokers.add("broker-2");
        String assignedNamespace = "my-tenant/use/my-ns0/0x00000000_0xffffffff";
        candidate.addAll(brokers);
        LoadManagerShared.filterAntiAffinityGroupOwnedBrokers((PulsarService)this.pulsar1, (String)assignedNamespace, (Set)brokers, (ConcurrentOpenHashMap)brokerToNamespaceToBundleRange, null);
        Assert.assertEquals((int)brokers.size(), (int)3);
        this.selectBrokerForNamespace((ConcurrentOpenHashMap<String, ConcurrentOpenHashMap<String, ConcurrentOpenHashSet<String>>>)brokerToNamespaceToBundleRange, "broker-0", "my-tenant/use/my-ns0", assignedNamespace);
        candidate.addAll(brokers);
        assignedNamespace = "my-tenant/use/my-ns1/0x00000000_0xffffffff";
        LoadManagerShared.filterAntiAffinityGroupOwnedBrokers((PulsarService)this.pulsar1, (String)assignedNamespace, (Set)candidate, (ConcurrentOpenHashMap)brokerToNamespaceToBundleRange, null);
        Assert.assertEquals((int)candidate.size(), (int)2);
        Assert.assertTrue((boolean)candidate.contains("broker-1"));
        Assert.assertTrue((boolean)candidate.contains("broker-2"));
        this.selectBrokerForNamespace((ConcurrentOpenHashMap<String, ConcurrentOpenHashMap<String, ConcurrentOpenHashSet<String>>>)brokerToNamespaceToBundleRange, "broker-1", "my-tenant/use/my-ns1", assignedNamespace);
        candidate.addAll(brokers);
        assignedNamespace = "my-tenant/use/my-ns2/0x00000000_0xffffffff";
        LoadManagerShared.filterAntiAffinityGroupOwnedBrokers((PulsarService)this.pulsar1, (String)assignedNamespace, (Set)candidate, (ConcurrentOpenHashMap)brokerToNamespaceToBundleRange, null);
        Assert.assertEquals((int)candidate.size(), (int)1);
        Assert.assertTrue((boolean)candidate.contains("broker-2"));
        this.selectBrokerForNamespace((ConcurrentOpenHashMap<String, ConcurrentOpenHashMap<String, ConcurrentOpenHashSet<String>>>)brokerToNamespaceToBundleRange, "broker-2", "my-tenant/use/my-ns2", assignedNamespace);
        candidate.addAll(brokers);
        assignedNamespace = "my-tenant/use/my-ns3/0x00000000_0xffffffff";
        LoadManagerShared.filterAntiAffinityGroupOwnedBrokers((PulsarService)this.pulsar1, (String)assignedNamespace, (Set)candidate, (ConcurrentOpenHashMap)brokerToNamespaceToBundleRange, null);
        Assert.assertEquals((int)candidate.size(), (int)3);
    }

    private void selectBrokerForNamespace(ConcurrentOpenHashMap<String, ConcurrentOpenHashMap<String, ConcurrentOpenHashSet<String>>> brokerToNamespaceToBundleRange, String broker, String namespace, String assignedBundleName) {
        ConcurrentOpenHashSet bundleSet = new ConcurrentOpenHashSet();
        bundleSet.add((Object)assignedBundleName);
        ConcurrentOpenHashMap nsToBundleMap = new ConcurrentOpenHashMap();
        nsToBundleMap.put((Object)namespace, (Object)bundleSet);
        brokerToNamespaceToBundleRange.put((Object)broker, (Object)nsToBundleMap);
    }

    @Test
    public void testBrokerSelectionForAntiAffinityGroup() throws Exception {
        String broker1 = this.primaryHost;
        String broker2 = this.secondaryHost;
        String cluster = this.pulsar1.getConfiguration().getClusterName();
        String tenant = "tenant-" + UUID.randomUUID().toString();
        String namespace1 = tenant + "/" + cluster + "/ns1";
        String namespace2 = tenant + "/" + cluster + "/ns2";
        String namespaceAntiAffinityGroup = "group";
        FailureDomain domain1 = FailureDomain.builder().brokers(Collections.singleton(broker1)).build();
        this.admin1.clusters().createFailureDomain(cluster, "domain1", domain1);
        FailureDomain domain2 = FailureDomain.builder().brokers(Collections.singleton(broker2)).build();
        this.admin1.clusters().createFailureDomain(cluster, "domain2", domain2);
        this.admin1.tenants().createTenant(tenant, (TenantInfo)new TenantInfoImpl(null, (Set)Sets.newHashSet((Object[])new String[]{cluster})));
        this.admin1.namespaces().createNamespace(namespace1);
        this.admin1.namespaces().createNamespace(namespace2);
        this.admin1.namespaces().setNamespaceAntiAffinityGroup(namespace1, "group");
        this.admin1.namespaces().setNamespaceAntiAffinityGroup(namespace2, "group");
        for (int i = 0; !(i >= 5 || this.isLoadManagerUpdatedDomainCache(this.primaryLoadManager) && this.isLoadManagerUpdatedDomainCache(this.secondaryLoadManager)); ++i) {
            Thread.sleep(200L);
        }
        Assert.assertTrue((boolean)this.isLoadManagerUpdatedDomainCache(this.primaryLoadManager));
        Assert.assertTrue((boolean)this.isLoadManagerUpdatedDomainCache(this.secondaryLoadManager));
        NamespaceBundle serviceUnit1 = this.makeBundle(tenant, cluster, "ns1");
        String selectedBroker1 = (String)this.primaryLoadManager.selectBrokerForAssignment((ServiceUnitId)serviceUnit1).get();
        NamespaceBundle serviceUnit2 = this.makeBundle(tenant, cluster, "ns2");
        String selectedBroker2 = (String)this.primaryLoadManager.selectBrokerForAssignment((ServiceUnitId)serviceUnit2).get();
        Assert.assertNotEquals((Object)selectedBroker1, (Object)selectedBroker2);
    }

    @Test
    public void testLoadSheddingUtilWithAntiAffinityNamespace() throws Exception {
        String namespace = "my-tenant/use/my-ns";
        int totalNamespaces = 5;
        String namespaceAntiAffinityGroup = "my-antiaffinity";
        String bundle = "/0x00000000_0xffffffff";
        this.admin1.tenants().createTenant("my-tenant", (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"appid1", "appid2"}), (Set)Sets.newHashSet((Object[])new String[]{"use"})));
        for (int i = 0; i < 5; ++i) {
            String ns = "my-tenant/use/my-ns" + i;
            this.admin1.namespaces().createNamespace(ns);
            this.admin1.namespaces().setNamespaceAntiAffinityGroup(ns, "my-antiaffinity");
        }
        HashSet brokers = Sets.newHashSet();
        HashSet candidate = Sets.newHashSet();
        ConcurrentOpenHashMap brokerToNamespaceToBundleRange = new ConcurrentOpenHashMap();
        brokers.add("broker-0");
        brokers.add("broker-1");
        brokers.add("broker-2");
        String assignedNamespace = "my-tenant/use/my-ns0/0x00000000_0xffffffff";
        candidate.addAll(brokers);
        this.selectBrokerForNamespace((ConcurrentOpenHashMap<String, ConcurrentOpenHashMap<String, ConcurrentOpenHashSet<String>>>)brokerToNamespaceToBundleRange, "broker-0", "my-tenant/use/my-ns0", assignedNamespace);
        String currentBroker = "broker-0";
        boolean shouldUnload = LoadManagerShared.shouldAntiAffinityNamespaceUnload((String)"my-tenant/use/my-ns0", (String)"/0x00000000_0xffffffff", (String)currentBroker, (PulsarService)this.pulsar1, (ConcurrentOpenHashMap)brokerToNamespaceToBundleRange, (Set)candidate);
        Assert.assertTrue((boolean)shouldUnload);
        this.selectBrokerForNamespace((ConcurrentOpenHashMap<String, ConcurrentOpenHashMap<String, ConcurrentOpenHashSet<String>>>)brokerToNamespaceToBundleRange, "broker-1", "my-tenant/use/my-ns1", assignedNamespace);
        shouldUnload = LoadManagerShared.shouldAntiAffinityNamespaceUnload((String)"my-tenant/use/my-ns0", (String)"/0x00000000_0xffffffff", (String)currentBroker, (PulsarService)this.pulsar1, (ConcurrentOpenHashMap)brokerToNamespaceToBundleRange, (Set)candidate);
        Assert.assertTrue((boolean)shouldUnload);
        this.selectBrokerForNamespace((ConcurrentOpenHashMap<String, ConcurrentOpenHashMap<String, ConcurrentOpenHashSet<String>>>)brokerToNamespaceToBundleRange, "broker-2", "my-tenant/use/my-ns2", assignedNamespace);
        shouldUnload = LoadManagerShared.shouldAntiAffinityNamespaceUnload((String)"my-tenant/use/my-ns0", (String)"/0x00000000_0xffffffff", (String)currentBroker, (PulsarService)this.pulsar1, (ConcurrentOpenHashMap)brokerToNamespaceToBundleRange, (Set)candidate);
        Assert.assertFalse((boolean)shouldUnload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadSheddingWithAntiAffinityNamespace() throws Exception {
        String namespace = "my-tenant/use/my-ns";
        int totalNamespaces = 5;
        String namespaceAntiAffinityGroup = "my-antiaffinity";
        String bundle = "0x00000000_0xffffffff";
        this.admin1.tenants().createTenant("my-tenant", (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"appid1", "appid2"}), (Set)Sets.newHashSet((Object[])new String[]{"use"})));
        for (int i = 0; i < 5; ++i) {
            String ns = "my-tenant/use/my-ns" + i;
            this.admin1.namespaces().createNamespace(ns);
            this.admin1.namespaces().setNamespaceAntiAffinityGroup(ns, "my-antiaffinity");
        }
        PulsarClient pulsarClient = PulsarClient.builder().serviceUrl(this.pulsar1.getSafeWebServiceAddress()).build();
        try {
            Producer producer = pulsarClient.newProducer().topic("persistent://my-tenant/use/my-ns0/my-topic1").create();
            ModularLoadManagerImpl loadManager = (ModularLoadManagerImpl)((ModularLoadManagerWrapper)this.pulsar1.getLoadManager().get()).getLoadManager();
            this.pulsar1.getBrokerService().updateRates();
            loadManager.updateAll();
            Assert.assertTrue((boolean)loadManager.shouldAntiAffinityNamespaceUnload("my-tenant/use/my-ns0", "0x00000000_0xffffffff", this.primaryHost));
            producer.close();
        }
        finally {
            if (Collections.singletonList(pulsarClient).get(0) != null) {
                pulsarClient.close();
            }
        }
    }

    private boolean isLoadManagerUpdatedDomainCache(ModularLoadManagerImpl loadManager) throws Exception {
        Field mapField = ModularLoadManagerImpl.class.getDeclaredField("brokerToFailureDomainMap");
        mapField.setAccessible(true);
        Map map = (Map)mapField.get(loadManager);
        return !map.isEmpty();
    }

    private NamespaceBundle makeBundle(String property, String cluster, String namespace) {
        return this.nsFactory.getBundle(NamespaceName.get((String)property, (String)cluster, (String)namespace), Range.range((Comparable)NamespaceBundles.FULL_LOWER_BOUND, (BoundType)BoundType.CLOSED, (Comparable)NamespaceBundles.FULL_UPPER_BOUND, (BoundType)BoundType.CLOSED));
    }
}

