/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.namespace;

import com.google.common.base.Preconditions;
import com.google.common.hash.Hashing;
import java.util.EnumSet;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.cache.LocalZooKeeperCacheService;
import org.apache.pulsar.broker.namespace.NamespaceEphemeralData;
import org.apache.pulsar.broker.namespace.NamespaceService;
import org.apache.pulsar.broker.namespace.OwnedBundle;
import org.apache.pulsar.broker.namespace.OwnershipCache;
import org.apache.pulsar.broker.namespace.ServiceUnitUtils;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.NamespaceBundleFactory;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.extended.CreateOption;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.zookeeper.LocalZooKeeperCache;
import org.apache.pulsar.zookeeper.ZooKeeperCache;
import org.apache.pulsar.zookeeper.ZooKeeperCacheListener;
import org.apache.pulsar.zookeeper.ZooKeeperDataCache;
import org.apache.pulsar.zookeeper.ZookeeperServerTest;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.MockZooKeeper;
import org.apache.zookeeper.ZooKeeper;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.powermock.reflect.Whitebox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class OwnershipCacheTest {
    private static final Logger log = LoggerFactory.getLogger(OwnershipCacheTest.class);
    private PulsarService pulsar;
    private ServiceConfiguration config;
    private String selfBrokerUrl;
    private ZooKeeperCache zkCache;
    private LocalZooKeeperCacheService localCache;
    private NamespaceBundleFactory bundleFactory;
    private NamespaceService nsService;
    private BrokerService brokerService;
    private OrderedScheduler executor;
    private ZooKeeper zkc;
    private MetadataStoreExtended store;
    private MetadataStoreExtended otherStore;
    private MockZooKeeper mockZkc;
    private ZookeeperServerTest zookeeperServer;

    @BeforeMethod
    public void setup() throws Exception {
        int port = 8080;
        this.selfBrokerUrl = "tcp://localhost:8080";
        this.pulsar = (PulsarService)Mockito.mock(PulsarService.class);
        this.config = (ServiceConfiguration)Mockito.mock(ServiceConfiguration.class);
        this.executor = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().numThreads(1).name("test").build();
        this.zookeeperServer = new ZookeeperServerTest(0);
        this.zookeeperServer.start();
        this.store = MetadataStoreExtended.create((String)this.zookeeperServer.getHostPort(), (MetadataStoreConfig)MetadataStoreConfig.builder().sessionTimeoutMillis(5000).build());
        this.otherStore = MetadataStoreExtended.create((String)this.zookeeperServer.getHostPort(), (MetadataStoreConfig)MetadataStoreConfig.builder().sessionTimeoutMillis(5000).build());
        this.mockZkc = MockZooKeeper.newInstance();
        this.zkc = new ZooKeeper(this.zookeeperServer.getHostPort(), 5000, null);
        this.zkCache = new LocalZooKeeperCache(this.zkc, 30, (OrderedExecutor)this.executor);
        this.localCache = (LocalZooKeeperCacheService)Mockito.spy((Object)new LocalZooKeeperCacheService(this.zkCache, null));
        ZooKeeperDataCache poilciesCache = (ZooKeeperDataCache)Mockito.mock(ZooKeeperDataCache.class);
        Mockito.when((Object)this.pulsar.getLocalZkCacheService()).thenReturn((Object)this.localCache);
        Mockito.when((Object)this.localCache.policiesCache()).thenReturn((Object)poilciesCache);
        Mockito.when((Object)this.pulsar.getConfigurationMetadataStore()).thenReturn((Object)this.store);
        ((ZooKeeperDataCache)Mockito.doNothing().when((Object)poilciesCache)).registerListener((ZooKeeperCacheListener)ArgumentMatchers.any());
        Mockito.when((Object)this.pulsar.getLocalMetadataStore()).thenReturn((Object)this.store);
        this.bundleFactory = new NamespaceBundleFactory(this.pulsar, Hashing.crc32());
        this.nsService = (NamespaceService)Mockito.mock(NamespaceService.class);
        this.brokerService = (BrokerService)Mockito.mock(BrokerService.class);
        ((BrokerService)Mockito.doReturn(CompletableFuture.completedFuture(1)).when((Object)this.brokerService)).unloadServiceUnit((NamespaceBundle)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (long)ArgumentMatchers.anyInt(), (TimeUnit)((Object)ArgumentMatchers.any()));
        ((PulsarService)Mockito.doReturn((Object)this.zkCache).when((Object)this.pulsar)).getLocalZkCache();
        ((PulsarService)Mockito.doReturn((Object)this.localCache).when((Object)this.pulsar)).getLocalZkCacheService();
        ((PulsarService)Mockito.doReturn((Object)this.config).when((Object)this.pulsar)).getConfiguration();
        ((PulsarService)Mockito.doReturn((Object)this.nsService).when((Object)this.pulsar)).getNamespaceService();
        ((ServiceConfiguration)Mockito.doReturn(Optional.of(8080)).when((Object)this.config)).getBrokerServicePort();
        ((ServiceConfiguration)Mockito.doReturn(Optional.empty()).when((Object)this.config)).getWebServicePort();
        ((PulsarService)Mockito.doReturn((Object)this.brokerService).when((Object)this.pulsar)).getBrokerService();
        ((PulsarService)Mockito.doReturn((Object)this.selfBrokerUrl).when((Object)this.pulsar)).getSafeBrokerServiceUrl();
    }

    @AfterMethod(alwaysRun=true)
    public void teardown() throws Exception {
        this.executor.shutdownNow();
        this.zkCache.stop();
        this.zkc.close();
        this.store.close();
        this.otherStore.close();
        this.mockZkc.close();
        this.zookeeperServer.close();
    }

    @Test
    public void testConstructor() {
        OwnershipCache cache = new OwnershipCache(this.pulsar, this.bundleFactory, this.nsService);
        Assert.assertNotNull((Object)cache);
        Assert.assertNotNull((Object)cache.getOwnedBundles());
    }

    @Test
    public void testDisableOwnership() throws Exception {
        OwnershipCache cache = new OwnershipCache(this.pulsar, this.bundleFactory, this.nsService);
        NamespaceBundle testBundle = this.bundleFactory.getFullBundle(NamespaceName.get((String)"pulsar/test/ns-1"));
        Assert.assertFalse((boolean)((Optional)cache.getOwnerAsync(testBundle).get()).isPresent());
        NamespaceEphemeralData data1 = (NamespaceEphemeralData)cache.tryAcquiringOwnership(testBundle).get();
        Assert.assertFalse((boolean)data1.isDisabled());
        cache.disableOwnership(testBundle);
        data1 = (NamespaceEphemeralData)((Optional)cache.getOwnerAsync(testBundle).get()).get();
        Assert.assertTrue((boolean)data1.isDisabled());
    }

    @Test
    public void testGetOrSetOwner() throws Exception {
        OwnershipCache cache = new OwnershipCache(this.pulsar, this.bundleFactory, this.nsService);
        NamespaceBundle testFullBundle = this.bundleFactory.getFullBundle(NamespaceName.get((String)"pulsar/test/ns-2"));
        Assert.assertFalse((boolean)((Optional)cache.getOwnerAsync(testFullBundle).get()).isPresent());
        NamespaceEphemeralData data1 = (NamespaceEphemeralData)cache.tryAcquiringOwnership(testFullBundle).get();
        Assert.assertEquals((String)data1.getNativeUrl(), (String)this.selfBrokerUrl);
        Assert.assertFalse((boolean)data1.isDisabled());
        OwnedBundle nsObj = cache.getOwnedBundle(testFullBundle);
        ((NamespaceService)Mockito.doReturn((Object)cache).when((Object)this.nsService)).getOwnershipCache();
        nsObj.handleUnloadRequest(this.pulsar, 5L, TimeUnit.SECONDS).join();
        Thread.sleep(1000L);
        this.localCache.ownerInfoCache().invalidate(ServiceUnitUtils.path((NamespaceBundle)testFullBundle));
        this.pulsar.getLocalMetadataStore().put(ServiceUnitUtils.path((NamespaceBundle)testFullBundle), ObjectMapperFactory.getThreadLocal().writeValueAsBytes((Object)new NamespaceEphemeralData("pulsar://otherhost:8881", "pulsar://otherhost:8884", "http://localhost:8080", "https://localhost:4443", false)), Optional.of(-1L), EnumSet.of(CreateOption.Ephemeral)).join();
        data1 = (NamespaceEphemeralData)cache.tryAcquiringOwnership(testFullBundle).get();
        Assert.assertEquals((String)data1.getNativeUrl(), (String)"pulsar://otherhost:8881");
        Assert.assertEquals((String)data1.getNativeUrlTls(), (String)"pulsar://otherhost:8884");
        Assert.assertFalse((boolean)data1.isDisabled());
    }

    @Test
    public void testGetOwner() throws Exception {
        OwnershipCache cache = new OwnershipCache(this.pulsar, this.bundleFactory, this.nsService);
        NamespaceBundle testBundle = this.bundleFactory.getFullBundle(NamespaceName.get((String)"pulsar/test/ns-3"));
        Assert.assertFalse((boolean)((Optional)cache.getOwnerAsync(testBundle).get()).isPresent());
        this.pulsar.getLocalMetadataStore().put(ServiceUnitUtils.path((NamespaceBundle)testBundle), ObjectMapperFactory.getThreadLocal().writeValueAsBytes((Object)new NamespaceEphemeralData("pulsar://otherhost:8881", "pulsar://otherhost:8884", "http://localhost:8080", "https://localhost:4443", false)), Optional.of(-1L), EnumSet.of(CreateOption.Ephemeral)).join();
        NamespaceEphemeralData data1 = (NamespaceEphemeralData)cache.tryAcquiringOwnership(testBundle).get();
        Assert.assertEquals((String)data1.getNativeUrl(), (String)"pulsar://otherhost:8881");
        Assert.assertEquals((String)data1.getNativeUrlTls(), (String)"pulsar://otherhost:8884");
        Assert.assertFalse((boolean)data1.isDisabled());
        NamespaceEphemeralData readOnlyData = (NamespaceEphemeralData)((Optional)cache.getOwnerAsync(testBundle).get()).get();
        Assert.assertEquals((Object)data1, (Object)readOnlyData);
        AtomicReference zkSession = (AtomicReference)Whitebox.getInternalState((Object)this.zkCache, (String)"zkSession");
        ZooKeeper zooKeeper = (ZooKeeper)zkSession.get();
        zkSession.set(this.mockZkc);
        this.mockZkc.failConditional(KeeperException.Code.NONODE, (op, path) -> op == MockZooKeeper.Op.GET && path.equals("/namespace/pulsar/test/ns-none/0x00000000_0xffffffff"));
        Optional res = (Optional)cache.getOwnerAsync(this.bundleFactory.getFullBundle(NamespaceName.get((String)"pulsar/test/ns-none"))).get();
        Assert.assertFalse((boolean)res.isPresent());
        zkSession.set(zooKeeper);
    }

    @Test
    public void testGetOwnedServiceUnit() throws Exception {
        OwnershipCache cache = new OwnershipCache(this.pulsar, this.bundleFactory, this.nsService);
        NamespaceName testNs = NamespaceName.get((String)"pulsar/test/ns-5");
        NamespaceBundle testBundle = this.bundleFactory.getFullBundle(testNs);
        Assert.assertFalse((boolean)((Optional)cache.getOwnerAsync(testBundle).get()).isPresent());
        try {
            Preconditions.checkNotNull((Object)cache.getOwnedBundle(testBundle));
            Assert.fail((String)"Should have failed");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.otherStore.put(ServiceUnitUtils.path((NamespaceBundle)testBundle), ObjectMapperFactory.getThreadLocal().writeValueAsBytes((Object)new NamespaceEphemeralData("pulsar://otherhost:8881", "pulsar://otherhost:8884", "http://localhost:8080", "https://localhost:4443", false)), Optional.of(-1L), EnumSet.of(CreateOption.Ephemeral)).join();
        try {
            Preconditions.checkNotNull((Object)cache.getOwnedBundle(testBundle));
            Assert.fail((String)"Should have failed");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Thread.sleep(500L);
        NamespaceEphemeralData data1 = (NamespaceEphemeralData)cache.tryAcquiringOwnership(testBundle).get();
        Assert.assertEquals((String)data1.getNativeUrl(), (String)"pulsar://otherhost:8881");
        Assert.assertEquals((String)data1.getNativeUrlTls(), (String)"pulsar://otherhost:8884");
        Assert.assertFalse((boolean)data1.isDisabled());
        try {
            Preconditions.checkNotNull((Object)cache.getOwnedBundle(testBundle));
            Assert.fail((String)"Should have failed");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.otherStore.delete(ServiceUnitUtils.path((NamespaceBundle)testBundle), Optional.empty()).join();
        this.localCache.ownerInfoCache().invalidate(ServiceUnitUtils.path((NamespaceBundle)testBundle));
        data1 = (NamespaceEphemeralData)cache.tryAcquiringOwnership(testBundle).get();
        Assert.assertEquals((String)data1.getNativeUrl(), (String)this.selfBrokerUrl);
        Assert.assertFalse((boolean)data1.isDisabled());
        Assert.assertNotNull((Object)cache.getOwnedBundle(testBundle));
    }

    @Test
    public void testGetOwnedServiceUnits() throws Exception {
        OwnershipCache cache = new OwnershipCache(this.pulsar, this.bundleFactory, this.nsService);
        NamespaceName testNs = NamespaceName.get((String)"pulsar/test/ns-6");
        NamespaceBundle testBundle = this.bundleFactory.getFullBundle(testNs);
        Assert.assertFalse((boolean)((Optional)cache.getOwnerAsync(testBundle).get()).isPresent());
        Assert.assertTrue((boolean)cache.getOwnedBundles().isEmpty());
        this.otherStore.put(ServiceUnitUtils.path((NamespaceBundle)testBundle), ObjectMapperFactory.getThreadLocal().writeValueAsBytes((Object)new NamespaceEphemeralData("pulsar://otherhost:8881", "pulsar://otherhost:8884", "http://otherhost:8080", "https://otherhost:4443", false)), Optional.of(-1L), EnumSet.of(CreateOption.Ephemeral)).join();
        Assert.assertTrue((boolean)cache.getOwnedBundles().isEmpty());
        Thread.sleep(500L);
        NamespaceEphemeralData data1 = (NamespaceEphemeralData)cache.tryAcquiringOwnership(testBundle).get();
        Assert.assertEquals((String)data1.getNativeUrl(), (String)"pulsar://otherhost:8881");
        Assert.assertEquals((String)data1.getNativeUrlTls(), (String)"pulsar://otherhost:8884");
        Assert.assertFalse((boolean)data1.isDisabled());
        Assert.assertTrue((boolean)cache.getOwnedBundles().isEmpty());
        this.otherStore.delete(ServiceUnitUtils.path((NamespaceBundle)testBundle), Optional.empty()).join();
        this.localCache.ownerInfoCache().invalidate(ServiceUnitUtils.path((NamespaceBundle)testBundle));
        data1 = (NamespaceEphemeralData)cache.tryAcquiringOwnership(testBundle).get();
        Assert.assertEquals((String)data1.getNativeUrl(), (String)this.selfBrokerUrl);
        Assert.assertFalse((boolean)data1.isDisabled());
        Assert.assertEquals((int)cache.getOwnedBundles().size(), (int)1);
    }

    @Test
    public void testRemoveOwnership() throws Exception {
        OwnershipCache cache = new OwnershipCache(this.pulsar, this.bundleFactory, this.nsService);
        NamespaceName testNs = NamespaceName.get((String)"pulsar/test/ns-7");
        NamespaceBundle bundle = this.bundleFactory.getFullBundle(testNs);
        Assert.assertFalse((boolean)((Optional)cache.getOwnerAsync(bundle).get()).isPresent());
        cache.removeOwnership(bundle).get();
        Assert.assertTrue((boolean)cache.getOwnedBundles().isEmpty());
        NamespaceEphemeralData data1 = (NamespaceEphemeralData)cache.tryAcquiringOwnership(bundle).get();
        Assert.assertEquals((String)data1.getNativeUrl(), (String)this.selfBrokerUrl);
        Assert.assertFalse((boolean)data1.isDisabled());
        Assert.assertEquals((int)cache.getOwnedBundles().size(), (int)1);
        cache.removeOwnership(bundle);
        Thread.sleep(500L);
        Assert.assertTrue((boolean)cache.getOwnedBundles().isEmpty());
        Thread.sleep(500L);
        Assert.assertFalse((boolean)((Boolean)this.store.exists(ServiceUnitUtils.path((NamespaceBundle)bundle)).join()));
    }

    @Test
    public void testReestablishOwnership() throws Exception {
        OwnershipCache cache = new OwnershipCache(this.pulsar, this.bundleFactory, this.nsService);
        NamespaceBundle testFullBundle = this.bundleFactory.getFullBundle(NamespaceName.get((String)"pulsar/test/ns-8"));
        String testFullBundlePath = ServiceUnitUtils.path((NamespaceBundle)testFullBundle);
        Assert.assertFalse((boolean)((Optional)cache.getOwnerAsync(testFullBundle).get()).isPresent());
        Assert.assertNull((Object)cache.getOwnedBundle(testFullBundle));
        NamespaceEphemeralData data1 = (NamespaceEphemeralData)cache.tryAcquiringOwnership(testFullBundle).get();
        Assert.assertEquals((String)data1.getNativeUrl(), (String)this.selfBrokerUrl);
        Assert.assertFalse((boolean)data1.isDisabled());
        Assert.assertNotNull((Object)cache.getOwnedBundle(testFullBundle));
        cache.invalidateLocalOwnerCache();
        this.localCache.ownerInfoCache().invalidate(testFullBundlePath);
        Assert.assertNull((Object)cache.getOwnedBundle(testFullBundle));
        Assert.assertNull((Object)this.localCache.ownerInfoCache().getDataIfPresent(testFullBundlePath));
        NamespaceEphemeralData data2 = (NamespaceEphemeralData)((Optional)cache.getOwnerAsync(testFullBundle).get()).get();
        Assert.assertEquals((String)data2.getNativeUrl(), (String)this.selfBrokerUrl);
        Assert.assertFalse((boolean)data2.isDisabled());
        Assert.assertNotNull((Object)cache.getOwnedBundle(testFullBundle));
        cache.invalidateLocalOwnerCache();
        this.localCache.ownerInfoCache().invalidate(testFullBundlePath);
        Assert.assertNull((Object)cache.getOwnedBundle(testFullBundle));
        Assert.assertNull((Object)this.localCache.ownerInfoCache().getDataIfPresent(testFullBundlePath));
        NamespaceEphemeralData data3 = (NamespaceEphemeralData)cache.tryAcquiringOwnership(testFullBundle).get();
        Assert.assertEquals((String)data3.getNativeUrl(), (String)this.selfBrokerUrl);
        Assert.assertFalse((boolean)data3.isDisabled());
        Assert.assertNotNull((Object)cache.getOwnedBundle(testFullBundle));
        cache.invalidateLocalOwnerCache();
        this.localCache.ownerInfoCache().invalidate(testFullBundlePath);
        Assert.assertNull((Object)cache.getOwnedBundle(testFullBundle));
        Assert.assertNull((Object)this.localCache.ownerInfoCache().getDataIfPresent(testFullBundlePath));
        Assert.assertTrue((boolean)((Boolean)cache.checkOwnership(testFullBundle).join()));
        Assert.assertEquals((String)data2.getNativeUrl(), (String)this.selfBrokerUrl);
        Assert.assertFalse((boolean)data2.isDisabled());
        Assert.assertNotNull((Object)cache.getOwnedBundle(testFullBundle));
    }
}

