/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.ConsistentHashingStickyKeyConsumerSelector;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.client.api.Range;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class ConsistentHashingStickyKeyConsumerSelectorTest {
    @Test
    public void testConsumerSelect() throws BrokerServiceException.ConsumerAssignException {
        int count;
        int i;
        ConsistentHashingStickyKeyConsumerSelector selector = new ConsistentHashingStickyKeyConsumerSelector(100);
        String key1 = "anyKey";
        Assert.assertNull((Object)selector.select(key1.getBytes()));
        Consumer consumer1 = (Consumer)Mockito.mock(Consumer.class);
        Mockito.when((Object)consumer1.consumerName()).thenReturn((Object)"c1");
        selector.addConsumer(consumer1);
        Assert.assertEquals((Object)selector.select(key1.getBytes()), (Object)consumer1);
        Consumer consumer2 = (Consumer)Mockito.mock(Consumer.class);
        Mockito.when((Object)consumer2.consumerName()).thenReturn((Object)"c2");
        selector.addConsumer(consumer2);
        int N = 1000;
        double PERCENT_ERROR = 0.2;
        HashMap<String, Integer> selectionMap = new HashMap<String, Integer>();
        for (int i2 = 0; i2 < 1000; ++i2) {
            String key = UUID.randomUUID().toString();
            Consumer selectedConsumer = selector.select(key.getBytes());
            int count2 = selectionMap.computeIfAbsent(selectedConsumer.consumerName(), c -> 0);
            selectionMap.put(selectedConsumer.consumerName(), count2 + 1);
        }
        Assert.assertEquals((double)((Integer)selectionMap.get("c1")).intValue(), (double)500.0, (double)100.0);
        Assert.assertEquals((double)((Integer)selectionMap.get("c2")).intValue(), (double)500.0, (double)100.0);
        selectionMap.clear();
        Consumer consumer3 = (Consumer)Mockito.mock(Consumer.class);
        Mockito.when((Object)consumer3.consumerName()).thenReturn((Object)"c3");
        selector.addConsumer(consumer3);
        for (int i3 = 0; i3 < 1000; ++i3) {
            String key = UUID.randomUUID().toString();
            Consumer selectedConsumer = selector.select(key.getBytes());
            int count3 = selectionMap.computeIfAbsent(selectedConsumer.consumerName(), c -> 0);
            selectionMap.put(selectedConsumer.consumerName(), count3 + 1);
        }
        Assert.assertEquals((double)((Integer)selectionMap.get("c1")).intValue(), (double)333.0, (double)66.60000000000001);
        Assert.assertEquals((double)((Integer)selectionMap.get("c2")).intValue(), (double)333.0, (double)66.60000000000001);
        Assert.assertEquals((double)((Integer)selectionMap.get("c3")).intValue(), (double)333.0, (double)66.60000000000001);
        selectionMap.clear();
        Consumer consumer4 = (Consumer)Mockito.mock(Consumer.class);
        Mockito.when((Object)consumer4.consumerName()).thenReturn((Object)"c4");
        selector.addConsumer(consumer4);
        for (i = 0; i < 1000; ++i) {
            String key = UUID.randomUUID().toString();
            Consumer selectedConsumer = selector.select(key.getBytes());
            count = selectionMap.computeIfAbsent(selectedConsumer.consumerName(), c -> 0);
            selectionMap.put(selectedConsumer.consumerName(), count + 1);
        }
        Assert.assertEquals((double)((Integer)selectionMap.get("c1")).intValue(), (double)250.0, (double)50.0);
        Assert.assertEquals((double)((Integer)selectionMap.get("c2")).intValue(), (double)250.0, (double)50.0);
        Assert.assertEquals((double)((Integer)selectionMap.get("c3")).intValue(), (double)250.0, (double)50.0);
        Assert.assertEquals((double)((Integer)selectionMap.get("c4")).intValue(), (double)250.0, (double)50.0);
        selectionMap.clear();
        selector.removeConsumer(consumer1);
        for (i = 0; i < 1000; ++i) {
            String key = UUID.randomUUID().toString();
            Consumer selectedConsumer = selector.select(key.getBytes());
            count = selectionMap.computeIfAbsent(selectedConsumer.consumerName(), c -> 0);
            selectionMap.put(selectedConsumer.consumerName(), count + 1);
        }
        Assert.assertEquals((double)((Integer)selectionMap.get("c2")).intValue(), (double)333.0, (double)66.60000000000001);
        Assert.assertEquals((double)((Integer)selectionMap.get("c3")).intValue(), (double)333.0, (double)66.60000000000001);
        Assert.assertEquals((double)((Integer)selectionMap.get("c4")).intValue(), (double)333.0, (double)66.60000000000001);
        selectionMap.clear();
        selector.removeConsumer(consumer2);
        for (i = 0; i < 1000; ++i) {
            String key = UUID.randomUUID().toString();
            Consumer selectedConsumer = selector.select(key.getBytes());
            count = selectionMap.computeIfAbsent(selectedConsumer.consumerName(), c -> 0);
            selectionMap.put(selectedConsumer.consumerName(), count + 1);
        }
        System.err.println(selectionMap);
        Assert.assertEquals((double)((Integer)selectionMap.get("c3")).intValue(), (double)500.0, (double)100.0);
        Assert.assertEquals((double)((Integer)selectionMap.get("c4")).intValue(), (double)500.0, (double)100.0);
        selectionMap.clear();
        selector.removeConsumer(consumer3);
        for (i = 0; i < 1000; ++i) {
            String key = UUID.randomUUID().toString();
            Consumer selectedConsumer = selector.select(key.getBytes());
            count = selectionMap.computeIfAbsent(selectedConsumer.consumerName(), c -> 0);
            selectionMap.put(selectedConsumer.consumerName(), count + 1);
        }
        Assert.assertEquals((int)((Integer)selectionMap.get("c4")), (int)1000);
    }

    @Test
    public void testGetConsumerKeyHashRanges() throws BrokerServiceException.ConsumerAssignException {
        ConsistentHashingStickyKeyConsumerSelector selector = new ConsistentHashingStickyKeyConsumerSelector(3);
        List<String> consumerName = Arrays.asList("consumer1", "consumer2", "consumer3");
        ArrayList<Consumer> consumers = new ArrayList<Consumer>();
        for (String s : consumerName) {
            Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
            Mockito.when((Object)consumer.consumerName()).thenReturn((Object)s);
            selector.addConsumer(consumer);
            consumers.add(consumer);
        }
        HashMap<Consumer, List<Range>> expectedResult = new HashMap<Consumer, List<Range>>();
        expectedResult.put((Consumer)consumers.get(0), Arrays.asList(Range.of((int)0, (int)330121749), Range.of((int)330121750, (int)618146114), Range.of((int)1797637922, (int)1976098885)));
        expectedResult.put((Consumer)consumers.get(1), Arrays.asList(Range.of((int)938427576, (int)1094135919), Range.of((int)1138613629, (int)1342907082), Range.of((int)1342907083, (int)1797637921)));
        expectedResult.put((Consumer)consumers.get(2), Arrays.asList(Range.of((int)618146115, (int)772640562), Range.of((int)772640563, (int)938427575), Range.of((int)1094135920, (int)1138613628)));
        for (Map.Entry entry : selector.getConsumerKeyHashRanges().entrySet()) {
            System.out.println(entry.getValue());
            Assert.assertEquals((Collection)((Collection)entry.getValue()), (Collection)((Collection)expectedResult.get(entry.getKey())));
            expectedResult.remove(entry.getKey());
        }
        Assert.assertEquals((int)expectedResult.size(), (int)0);
    }
}

