/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.time.Duration;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.pulsar.broker.service.BrokerTestBase;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.awaitility.Awaitility;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class CurrentLedgerRolloverIfFullTest
extends BrokerTestBase {
    @Override
    @BeforeClass
    protected void setup() throws Exception {
        this.baseSetup();
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void cleanup() throws Exception {
        this.internalCleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCurrentLedgerRolloverIfFull() throws Exception {
        String topicName = "persistent://prop/ns-abc/CurrentLedgerRolloverIfFullTest";
        Producer producer = this.pulsarClient.newProducer().topic("persistent://prop/ns-abc/CurrentLedgerRolloverIfFullTest").producerName("CurrentLedgerRolloverIfFullTest-producer-name").create();
        try {
            Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{"persistent://prop/ns-abc/CurrentLedgerRolloverIfFullTest"}).subscriptionName("CurrentLedgerRolloverIfFullTest-subscriber-name").subscribe();
            try {
                Topic topicRef = (Topic)this.pulsar.getBrokerService().getTopicReference("persistent://prop/ns-abc/CurrentLedgerRolloverIfFullTest").get();
                Assert.assertNotNull((Object)topicRef);
                PersistentTopic persistentTopic = (PersistentTopic)this.pulsar.getBrokerService().getOrCreateTopic("persistent://prop/ns-abc/CurrentLedgerRolloverIfFullTest").get();
                ManagedLedgerConfig managedLedgerConfig = persistentTopic.getManagedLedger().getConfig();
                managedLedgerConfig.setRetentionTime(1, TimeUnit.SECONDS);
                managedLedgerConfig.setMaxEntriesPerLedger(2);
                managedLedgerConfig.setMinimumRolloverTime(1, TimeUnit.MILLISECONDS);
                managedLedgerConfig.setMaximumRolloverTime(1, TimeUnit.SECONDS);
                int msgNum = 10;
                for (int i = 0; i < msgNum; ++i) {
                    producer.send((Object)new byte[0x100000]);
                }
                ManagedLedgerImpl managedLedger = (ManagedLedgerImpl)persistentTopic.getManagedLedger();
                Assert.assertEquals((int)managedLedger.getLedgersInfoAsList().size(), (int)(msgNum / 2));
                for (int i = 0; i < msgNum; ++i) {
                    Message msg = consumer.receive(2, TimeUnit.SECONDS);
                    Assert.assertNotNull((Object)msg);
                    consumer.acknowledge(msg);
                }
                Awaitility.await().pollInterval(Duration.ofMillis(500L)).untilAsserted(() -> {
                    Assert.assertEquals((int)managedLedger.getLedgersInfoAsList().size(), (int)1);
                    Assert.assertNotEquals((Object)managedLedger.getCurrentLedgerSize(), (Object)0);
                });
                managedLedger.rollCurrentLedgerIfFull();
                Awaitility.await().pollInterval(Duration.ofMillis(1000L)).untilAsserted(() -> {
                    Assert.assertEquals((int)managedLedger.getLedgersInfoAsList().size(), (int)1);
                    Assert.assertEquals((long)managedLedger.getTotalSize(), (long)0L);
                });
            }
            finally {
                if (Collections.singletonList(consumer).get(0) != null) {
                    consumer.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(producer).get(0) != null) {
                producer.close();
            }
        }
    }
}

