/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.HashRangeExclusiveStickyKeyConsumerSelector;
import org.apache.pulsar.client.api.Range;
import org.apache.pulsar.common.api.proto.IntRange;
import org.apache.pulsar.common.api.proto.KeySharedMeta;
import org.apache.pulsar.common.api.proto.KeySharedMode;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class HashRangeExclusiveStickyKeyConsumerSelectorTest {
    @Test
    public void testConsumerSelect() throws BrokerServiceException.ConsumerAssignException {
        int i;
        Consumer selectedConsumer;
        HashRangeExclusiveStickyKeyConsumerSelector selector = new HashRangeExclusiveStickyKeyConsumerSelector(10);
        Consumer consumer1 = (Consumer)Mockito.mock(Consumer.class);
        KeySharedMeta keySharedMeta1 = new KeySharedMeta().setKeySharedMode(KeySharedMode.STICKY);
        keySharedMeta1.addHashRange().setStart(0).setEnd(2);
        Mockito.when((Object)consumer1.getKeySharedMeta()).thenReturn((Object)keySharedMeta1);
        Assert.assertEquals((Object)consumer1.getKeySharedMeta(), (Object)keySharedMeta1);
        selector.addConsumer(consumer1);
        Assert.assertEquals((int)selector.getRangeConsumer().size(), (int)2);
        for (int i2 = 0; i2 < 3; ++i2) {
            selectedConsumer = selector.select(i2);
            Assert.assertEquals((Object)selectedConsumer, (Object)consumer1);
        }
        selectedConsumer = selector.select(4);
        Assert.assertNull((Object)selectedConsumer);
        Consumer consumer2 = (Consumer)Mockito.mock(Consumer.class);
        KeySharedMeta keySharedMeta2 = new KeySharedMeta().setKeySharedMode(KeySharedMode.STICKY);
        keySharedMeta2.addHashRange().setStart(3).setEnd(9);
        Mockito.when((Object)consumer2.getKeySharedMeta()).thenReturn((Object)keySharedMeta2);
        Assert.assertEquals((Object)consumer2.getKeySharedMeta(), (Object)keySharedMeta2);
        selector.addConsumer(consumer2);
        Assert.assertEquals((int)selector.getRangeConsumer().size(), (int)4);
        for (i = 3; i < 10; ++i) {
            selectedConsumer = selector.select(i);
            Assert.assertEquals((Object)selectedConsumer, (Object)consumer2);
        }
        for (i = 0; i < 3; ++i) {
            selectedConsumer = selector.select(i);
            Assert.assertEquals((Object)selectedConsumer, (Object)consumer1);
        }
        selector.removeConsumer(consumer1);
        Assert.assertEquals((int)selector.getRangeConsumer().size(), (int)2);
        selectedConsumer = selector.select(1);
        Assert.assertNull((Object)selectedConsumer);
        selector.removeConsumer(consumer2);
        Assert.assertEquals((int)selector.getRangeConsumer().size(), (int)0);
        selectedConsumer = selector.select(5);
        Assert.assertNull((Object)selectedConsumer);
    }

    @Test(expectedExceptions={BrokerServiceException.ConsumerAssignException.class})
    public void testEmptyRanges() throws BrokerServiceException.ConsumerAssignException {
        HashRangeExclusiveStickyKeyConsumerSelector selector = new HashRangeExclusiveStickyKeyConsumerSelector(10);
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        KeySharedMeta keySharedMeta = new KeySharedMeta().setKeySharedMode(KeySharedMode.STICKY);
        Mockito.when((Object)consumer.getKeySharedMeta()).thenReturn((Object)keySharedMeta);
        selector.addConsumer(consumer);
    }

    @Test(expectedExceptions={BrokerServiceException.ConsumerAssignException.class})
    public void testNullKeySharedMeta() throws BrokerServiceException.ConsumerAssignException {
        HashRangeExclusiveStickyKeyConsumerSelector selector = new HashRangeExclusiveStickyKeyConsumerSelector(10);
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        Mockito.when((Object)consumer.getKeySharedMeta()).thenReturn(null);
        selector.addConsumer(consumer);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInvalidRangeTotal() {
        new HashRangeExclusiveStickyKeyConsumerSelector(0);
    }

    @Test
    public void testGetConsumerKeyHashRanges() throws BrokerServiceException.ConsumerAssignException {
        HashRangeExclusiveStickyKeyConsumerSelector selector = new HashRangeExclusiveStickyKeyConsumerSelector(10);
        List<String> consumerName = Arrays.asList("consumer1", "consumer2", "consumer3", "consumer4");
        List range = Arrays.asList({0, 2}, {3, 7}, {9, 12}, {15, 20});
        ArrayList<Consumer> consumers = new ArrayList<Consumer>();
        for (int index = 0; index < consumerName.size(); ++index) {
            Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
            KeySharedMeta keySharedMeta = new KeySharedMeta().setKeySharedMode(KeySharedMode.STICKY);
            keySharedMeta.addHashRange().setStart(((int[])range.get(index))[0]).setEnd(((int[])range.get(index))[1]);
            Mockito.when((Object)consumer.getKeySharedMeta()).thenReturn((Object)keySharedMeta);
            Mockito.when((Object)consumer.consumerName()).thenReturn((Object)consumerName.get(index));
            Assert.assertEquals((Object)consumer.getKeySharedMeta(), (Object)keySharedMeta);
            selector.addConsumer(consumer);
            consumers.add(consumer);
        }
        HashMap<Consumer, List<Range>> expectedResult = new HashMap<Consumer, List<Range>>();
        expectedResult.put((Consumer)consumers.get(0), Collections.singletonList(Range.of((int)0, (int)2)));
        expectedResult.put((Consumer)consumers.get(1), Collections.singletonList(Range.of((int)3, (int)7)));
        expectedResult.put((Consumer)consumers.get(2), Collections.singletonList(Range.of((int)9, (int)12)));
        expectedResult.put((Consumer)consumers.get(3), Collections.singletonList(Range.of((int)15, (int)20)));
        for (Map.Entry entry : selector.getConsumerKeyHashRanges().entrySet()) {
            Assert.assertEquals((Collection)((Collection)entry.getValue()), (Collection)((Collection)expectedResult.get(entry.getKey())));
            expectedResult.remove(entry.getKey());
        }
        Assert.assertEquals((int)expectedResult.size(), (int)0);
    }

    @Test
    public void testGetConsumerKeyHashRangesWithSameConsumerName() throws Exception {
        HashRangeExclusiveStickyKeyConsumerSelector selector = new HashRangeExclusiveStickyKeyConsumerSelector(10);
        String consumerName = "My-consumer";
        List range = Arrays.asList({0, 2}, {3, 7}, {9, 12});
        ArrayList<Consumer> consumers = new ArrayList<Consumer>();
        for (int i = 0; i < 3; ++i) {
            Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
            KeySharedMeta keySharedMeta = new KeySharedMeta().setKeySharedMode(KeySharedMode.STICKY);
            keySharedMeta.addHashRange().setStart(((int[])range.get(i))[0]).setEnd(((int[])range.get(i))[1]);
            Mockito.when((Object)consumer.getKeySharedMeta()).thenReturn((Object)keySharedMeta);
            Mockito.when((Object)consumer.consumerName()).thenReturn((Object)"My-consumer");
            Assert.assertEquals((Object)consumer.getKeySharedMeta(), (Object)keySharedMeta);
            selector.addConsumer(consumer);
            consumers.add(consumer);
        }
        List prev = null;
        for (Consumer consumer : consumers) {
            List ranges = (List)selector.getConsumerKeyHashRanges().get(consumer);
            Assert.assertEquals((int)ranges.size(), (int)1);
            if (prev != null) {
                Assert.assertNotEquals((Object)prev, (Object)ranges);
            }
            prev = ranges;
        }
    }

    @Test
    public void testSingleRangeConflict() throws BrokerServiceException.ConsumerAssignException {
        HashRangeExclusiveStickyKeyConsumerSelector selector = new HashRangeExclusiveStickyKeyConsumerSelector(10);
        Consumer consumer1 = (Consumer)Mockito.mock(Consumer.class);
        KeySharedMeta keySharedMeta1 = new KeySharedMeta().setKeySharedMode(KeySharedMode.STICKY);
        keySharedMeta1.addHashRange().setStart(2).setEnd(5);
        Mockito.when((Object)consumer1.getKeySharedMeta()).thenReturn((Object)keySharedMeta1);
        Assert.assertEquals((Object)consumer1.getKeySharedMeta(), (Object)keySharedMeta1);
        selector.addConsumer(consumer1);
        Assert.assertEquals((int)selector.getRangeConsumer().size(), (int)2);
        ArrayList<IntRange> testRanges = new ArrayList<IntRange>();
        testRanges.add(new IntRange().setStart(4).setEnd(6));
        testRanges.add(new IntRange().setStart(1).setEnd(3));
        testRanges.add(new IntRange().setStart(2).setEnd(2));
        testRanges.add(new IntRange().setStart(5).setEnd(5));
        testRanges.add(new IntRange().setStart(1).setEnd(5));
        testRanges.add(new IntRange().setStart(2).setEnd(6));
        testRanges.add(new IntRange().setStart(2).setEnd(5));
        testRanges.add(new IntRange().setStart(1).setEnd(6));
        testRanges.add(new IntRange().setStart(8).setEnd(6));
        for (IntRange testRange : testRanges) {
            Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
            KeySharedMeta keySharedMeta = new KeySharedMeta().setKeySharedMode(KeySharedMode.STICKY);
            keySharedMeta.addHashRange().copyFrom(testRange);
            Mockito.when((Object)consumer.getKeySharedMeta()).thenReturn((Object)keySharedMeta);
            Assert.assertEquals((Object)consumer.getKeySharedMeta(), (Object)keySharedMeta);
            try {
                selector.addConsumer(consumer);
                Assert.fail((String)"should be failed");
            }
            catch (BrokerServiceException.ConsumerAssignException consumerAssignException) {
                // empty catch block
            }
            Assert.assertEquals((int)selector.getRangeConsumer().size(), (int)2);
        }
    }

    @Test
    public void testMultipleRangeConflict() throws BrokerServiceException.ConsumerAssignException {
        HashRangeExclusiveStickyKeyConsumerSelector selector = new HashRangeExclusiveStickyKeyConsumerSelector(10);
        Consumer consumer1 = (Consumer)Mockito.mock(Consumer.class);
        KeySharedMeta keySharedMeta1 = new KeySharedMeta().setKeySharedMode(KeySharedMode.STICKY);
        keySharedMeta1.addHashRange().setStart(2).setEnd(5);
        Mockito.when((Object)consumer1.getKeySharedMeta()).thenReturn((Object)keySharedMeta1);
        Assert.assertEquals((Object)consumer1.getKeySharedMeta(), (Object)keySharedMeta1);
        selector.addConsumer(consumer1);
        Assert.assertEquals((int)selector.getRangeConsumer().size(), (int)2);
        ArrayList<ArrayList> testRanges = new ArrayList<ArrayList>();
        testRanges.add(Lists.newArrayList((Object[])new IntRange[]{new IntRange().setStart(2).setEnd(2), new IntRange().setStart(3).setEnd(3), new IntRange().setStart(4).setEnd(5)}));
        testRanges.add(Lists.newArrayList((Object[])new IntRange[]{new IntRange().setStart(0).setEnd(0), new IntRange().setStart(1).setEnd(2)}));
        for (List list : testRanges) {
            Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
            KeySharedMeta keySharedMeta = new KeySharedMeta().setKeySharedMode(KeySharedMode.STICKY).addAllHashRanges((Iterable)list);
            Mockito.when((Object)consumer.getKeySharedMeta()).thenReturn((Object)keySharedMeta);
            Assert.assertEquals((Object)consumer.getKeySharedMeta(), (Object)keySharedMeta);
            try {
                selector.addConsumer(consumer);
                Assert.fail((String)"should be failed");
            }
            catch (BrokerServiceException.ConsumerAssignException consumerAssignException) {
                // empty catch block
            }
            Assert.assertEquals((int)selector.getRangeConsumer().size(), (int)2);
        }
    }
}

