/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.mledger.proto.MLDataFormats;
import org.apache.pulsar.broker.service.BrokerTestBase;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClientException;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"broker", "broker-jdk8"})
public class ManagedLedgerCompressionTest
extends BrokerTestBase {
    @Override
    @BeforeClass
    protected void setup() throws Exception {
        this.conf.setManagedLedgerInfoCompressionType(MLDataFormats.CompressionType.NONE.name());
        super.baseSetup();
    }

    @Override
    @AfterClass
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeOut=20000L)
    public void testRestartBrokerEnableManagedLedgerInfoCompression() throws Exception {
        String topic = this.newTopicName();
        Producer producer = this.pulsarClient.newProducer().topic(topic).create();
        try {
            Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{topic}).subscriptionName("test").subscribe();
            try {
                int messageCnt = 100;
                this.produceAndConsume((Producer<byte[]>)producer, (Consumer<byte[]>)consumer, messageCnt);
                this.stopBroker();
                this.conf.setManagedLedgerInfoCompressionType(MLDataFormats.CompressionType.ZSTD.name());
                this.startBroker();
                this.produceAndConsume((Producer<byte[]>)producer, (Consumer<byte[]>)consumer, messageCnt);
                this.stopBroker();
                this.conf.setManagedLedgerInfoCompressionType(MLDataFormats.CompressionType.LZ4.name());
                this.startBroker();
                this.produceAndConsume((Producer<byte[]>)producer, (Consumer<byte[]>)consumer, messageCnt);
                this.stopBroker();
                this.conf.setManagedLedgerInfoCompressionType("INVALID");
                try {
                    this.startBroker();
                    Assert.fail((String)"The managedLedgerInfo compression type is invalid, should fail.");
                }
                catch (Exception e) {
                    Assert.assertEquals(e.getCause().getClass(), IllegalArgumentException.class);
                    Assert.assertEquals((String)"No enum constant org.apache.bookkeeper.mledger.proto.MLDataFormats.CompressionType.INVALID", (String)e.getCause().getMessage());
                }
                this.conf.setManagedLedgerInfoCompressionType(MLDataFormats.CompressionType.NONE.name());
                this.startBroker();
                this.produceAndConsume((Producer<byte[]>)producer, (Consumer<byte[]>)consumer, messageCnt);
            }
            finally {
                if (Collections.singletonList(consumer).get(0) != null) {
                    consumer.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(producer).get(0) != null) {
                producer.close();
            }
        }
    }

    private void produceAndConsume(Producer<byte[]> producer, Consumer<byte[]> consumer, int messageCnt) throws PulsarClientException {
        int i;
        for (i = 0; i < messageCnt; ++i) {
            producer.newMessage().value((Object)"test".getBytes()).send();
        }
        for (i = 0; i < messageCnt; ++i) {
            Message message = consumer.receive(1000, TimeUnit.SECONDS);
            consumer.acknowledge(message);
            Assert.assertNotNull((Object)message);
        }
    }
}

